/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import uk.ac.rhul.cs.cl1.ClusterONEAlgorithmParameters;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.seeding.NodeSetCollectionBasedSeedGenerator;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.AbstractClusterONEAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeApp;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeTask;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ControlPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CyNetworkUtil;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.Graph;

public class GrowClusterAction
extends AbstractClusterONEAction
implements ClusterONECytoscapeTask.ResultListener {
    private CyNode node = null;

    public GrowClusterAction(ClusterONECytoscapeApp app) {
        super(app, "Grow cluster from selected nodes", "selectedNodes");
        this.installInMenu();
        this.putValue("MnemonicKey", 83);
    }

    public GrowClusterAction(ClusterONECytoscapeApp app, CyNode node) {
        super(app, "Grow cluster from this node");
        this.putValue("MnemonicKey", 71);
        this.node = node;
    }

    public void actionPerformed(ActionEvent event) {
        ControlPanel panel = this.app.getControlPanel();
        if (panel == null) {
            this.app.showErrorMessage("You must open the Control Panel before starting ClusterONE");
            return;
        }
        CyNetworkView networkView = this.app.getCurrentNetworkView();
        ClusterONEAlgorithmParameters parameters = panel.getParameters();
        String weightAttr = panel.getWeightAttributeName();
        CyNetwork network = this.app.getCurrentNetwork();
        Graph graph = this.app.convertCyNetworkToGraph(network, weightAttr);
        if (graph == null) {
            return;
        }
        List<CyNode> nodeMapping = graph.getNodeMapping();
        ArrayList<Integer> nodeIndices = new ArrayList<Integer>();
        if (this.node != null) {
            nodeIndices.add(nodeMapping.indexOf(this.node));
            if ((Integer)nodeIndices.get(0) < 0) {
                this.app.showBugMessage("The selected node does not belong to the selected graph.");
                return;
            }
        } else {
            List<CyNode> selectedNodes = CyNetworkUtil.getSelectedNodes(network);
            for (int idx = 0; idx < nodeMapping.size(); ++idx) {
                if (!selectedNodes.contains(nodeMapping.get(idx))) continue;
                nodeIndices.add(idx);
            }
        }
        if (nodeIndices.size() == 0) {
            this.app.showErrorMessage("There are no selected nodes in the current graph.");
            return;
        }
        parameters.setSeedGenerator(new NodeSetCollectionBasedSeedGenerator(new NodeSet((uk.ac.rhul.cs.graph.Graph)graph, nodeIndices)));
        this.app.runAlgorithm(networkView, parameters, weightAttr, (ClusterONECytoscapeTask.ResultListener)this);
    }

    public void resultsCalculated(ClusterONECytoscapeTask task, ClusterONECytoscapeTask.Result result) {
        if (result == null || result.clusters == null) {
            this.app.showBugMessage("No results returned from ClusterONE.");
            return;
        }
        if (result.clusters.size() == 0) {
            this.app.showInformationMessage("There is no cluster associated to the selection.\nMaybe it was filtered out by the size or the density filter?");
            return;
        }
        if (result.clusters.size() > 1) {
            this.app.showBugMessage("More than one cluster was returned from ClusterONE.");
            return;
        }
        NodeSet cluster = (NodeSet)result.clusters.get(0);
        ArrayList<CyNode> selectedNodes = new ArrayList<CyNode>();
        for (int idx : cluster) {
            selectedNodes.add(result.nodeMapping.get(idx));
        }
        CyNetworkView networkView = task.getNetworkView();
        CyNetwork network = task.getNetwork();
        if (network != null) {
            CyNetworkUtil.unselectAllNodes(network);
            CyNetworkUtil.unselectAllEdges(network);
            CyNetworkUtil.setSelectedState(network, selectedNodes, true);
            CyNetworkUtil.setSelectedState(network, CyNetworkUtil.getConnectingEdges(network, selectedNodes), true);
        }
        if (networkView != null) {
            networkView.updateView();
        }
    }
}

