/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1;

import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.QualityFunction;

public class LogLikelihoodFunction
implements QualityFunction {
    private static double binaryEntropy(double x) {
        if (x == 0.0 || x == 1.0) {
            return 0.0;
        }
        return x * Math.log(x) + (1.0 - x) * Math.log(1.0 - x);
    }

    public double calculate(NodeSet nodeSet) {
        if (nodeSet.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        double n = nodeSet.size();
        double N = nodeSet.getGraph().getNodeCount();
        double maxInternalEdges = n * (n - 1.0) / 2.0;
        double maxBoundaryEdges = n * (N - n);
        double p = n / N;
        double p1 = n == 1.0 ? 0.0 : nodeSet.getTotalInternalEdgeWeight() / maxInternalEdges;
        double p2 = n == N ? 0.0 : nodeSet.getTotalBoundaryEdgeWeight() / maxBoundaryEdges;
        double result = N * LogLikelihoodFunction.binaryEntropy(p);
        result += maxInternalEdges * LogLikelihoodFunction.binaryEntropy(p1);
        return result += maxBoundaryEdges * LogLikelihoodFunction.binaryEntropy(p2);
    }

    public double getAdditionAffinity(MutableNodeSet nodeSet, int index) {
        if (nodeSet.contains(index)) {
            return this.calculate(nodeSet);
        }
        MutableNodeSet copy = new MutableNodeSet(nodeSet);
        copy.add(index);
        return this.calculate(copy);
    }

    public double getRemovalAffinity(MutableNodeSet nodeSet, int index) {
        if (!nodeSet.contains(index)) {
            return this.calculate(nodeSet);
        }
        MutableNodeSet copy = new MutableNodeSet(nodeSet);
        copy.remove(index);
        return this.calculate(copy);
    }
}

