% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Data.Image-class.R
\docType{class}
\name{RLum.Data.Image-class}
\alias{RLum.Data.Image-class}
\alias{show,RLum.Data.Image-method}
\alias{set_RLum,RLum.Data.Image-method}
\alias{get_RLum,RLum.Data.Image-method}
\alias{names_RLum,RLum.Data.Image-method}
\title{Class \code{"RLum.Data.Image"}}
\usage{
\S4method{show}{RLum.Data.Image}(object)

\S4method{set_RLum}{RLum.Data.Image}(class, originator, .uid, .pid,
  recordType = "Image", curveType = NA_character_,
  data = raster::brick(raster::raster(matrix())), info = list())

\S4method{get_RLum}{RLum.Data.Image}(object, info.object)

\S4method{names_RLum}{RLum.Data.Image}(object)
}
\arguments{
\item{object}{\code{[show_RLum]}\code{[get_RLum]}\code{[names_RLum]} an object
of class \code{\linkS4class{RLum.Data.Image}}}

\item{class}{\code{[set_RLum]}\code{\link{character}}: name of the \code{RLum} class to create}

\item{originator}{\code{[set_RLum]} \code{\link{character}} (automatic):
contains the name of the calling function (the function that produces this object); can be set manually.}

\item{.uid}{[\code{set_RLum}] \code{\link{character}} (automatic): sets an unique ID for this object
using the internal C++ function \code{.create_UID}.}

\item{.pid}{[\code{set_RLum}] \code{\link{character}} (with default): option to provide a parent id for nesting
at will.}

\item{recordType}{\code{[set_RLum]} \code{\link{character}}: record type (e.g. "OSL")}

\item{curveType}{\code{[set_RLum]} \code{\link{character}}: curve type (e.g. "predefined" or "measured")}

\item{data}{\code{[set_RLum]} \code{\link{matrix}}: raw curve data. If data is of type \code{RLum.Data.Image}
this can be used to re-construct the object.}

\item{info}{\code{[set_RLum]} \code{\link{list}}: info elements}

\item{info.object}{\code{[get_RLum]} \code{\link{character}} name of the info object to returned}
}
\value{
\bold{\code{set_RLum}}\cr

Returns an object from class \code{RLum.Data.Image}

\bold{\code{get_RLum}}\cr

(1) Returns the data object (\code{\link[raster]{brick}})\cr
(2) only the info object if \code{info.object} was set.\cr

\bold{\code{names_RLum}}\cr

Returns the names of the info elements
}
\description{
Class for representing luminescence image data (TL/OSL/RF). Such data are for example produced
by the function \code{\link{read_SPE2R}}
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show structure of \code{RLum.Data.Image} object

\item \code{set_RLum}: Construction method for RLum.Data.Image object. The slot info is optional
and predefined as empty list by default..

\item \code{get_RLum}: Accessor method for RLum.Data.Image object. The argument info.object is
optional to directly access the info elements. If no info element name is
provided, the raw image data (RasterBrick) will be returned.

\item \code{names_RLum}: Returns the names info elements coming along with this curve object
}}

\section{Slots}{

\describe{
\item{\code{recordType}}{Object of class \code{\link{character}}
containing the type of the curve (e.g. "OSL image", "TL image")}

\item{\code{curveType}}{Object of class \code{\link{character}} containing curve type, allowed values
are measured or predefined}

\item{\code{data}}{Object of class \code{\link[raster]{brick}} containing images (raster data).}

\item{\code{info}}{Object of class \code{\link{list}} containing further meta information objects}
}}

\note{
The class should only contain data for a set of images. For additional
elements the slot \code{info} can be used.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{set_RLum("RLum.Data.Image", ...)}.
}

\section{Class version}{
 0.4.0
}

\examples{

showClass("RLum.Data.Image")

##create empty RLum.Data.Image object
set_RLum(class = "RLum.Data.Image")

}
\seealso{
\code{\linkS4class{RLum}}, \code{\linkS4class{RLum.Data}},
\code{\link{plot_RLum}}, \code{\link{read_SPE2R}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
} 

\section{How to cite}{
Kreutzer, S. (2017). RLum.Data.Image-class(): Class 'RLum.Data.Image'. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.3. https://CRAN.R-project.org/package=Luminescence
}

\keyword{classes}
