% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deseq_analysis2.R
\name{Deseq_analysis2}
\alias{Deseq_analysis2}
\title{Deseq analysis}
\usage{
Deseq_analysis2(inputframe, condition, cutoff, control_name, paired, subject)
}
\arguments{
\item{inputframe}{Otu/gene/taxa table with all integer numeric variables.Rownames must be  Otu/gene/taxa names,colnames must be sample names with control in front and treatment behind. Reads table is recommended.}

\item{condition}{A character string which indicates group of samples}

\item{cutoff}{threshold of log2(Foldchange).Detail see in \code{\link[DESeq2]{DESeq}}}

\item{control_name}{A character indicating the control group name}

\item{paired}{Logical to determine if paired comparision would be used. TRUE or FALSE.}

\item{subject}{A character string which indicates paired design of samples}
}
\value{
Statistics dataframe of all otu/gene/taxa
}
\description{
Deseq analysis
}
\note{
\enumerate{
\item Inputframe must be all integer numeric variables without NA/NAN/inf! In case your data is not an integer one,a practical method is to multiply them in equal proportion(eg. x 1e6) then round them into integer
\item Regulation is judged by cutoff of qvalue(adjust p value).Detail see in \code{\link[DESeq2]{DESeq}}
\item Set cutoff as 1 is recommened.In case of too few taxa(eg. Phylum level deseq),cutoff can be set to 0.
\item if control_name is not given, the control group will be set according to ASCII
\item The function requires the 'DESeq2', 'S4Vectors', and 'tibble' packages.
}
}
\examples{
\donttest{
{
  ### Data preparation ###
  data(testotu)
  rownames(testotu) <- testotu[, 1]
  inputotu <- testotu[, -c(1, ncol(testotu))]
  head(inputotu)
  group <- c(rep("a", 10), rep("b", 10))

  ### DESeq analysis ###
  if (requireNamespace("DESeq2", quietly = TRUE) &&
    requireNamespace("S4Vectors", quietly = TRUE) &&
    requireNamespace("tibble", quietly = TRUE)) {
    Deseqresult <- Deseq_analysis2(
      inputframe = inputotu,
      condition = group,
      cutoff = 1,
      control_name = "b"
    )

    ### Paired DESeq analysis ###
    subject <- factor(c(1:10, 1:10))
    Deseqresult <- Deseq_analysis2(
      inputframe = inputotu,
      condition = group,
      cutoff = 1,
      control_name = "b",
      paired = TRUE,
      subject = subject
    )
  }
}
}
}
\seealso{
\code{\link[DESeq2]{DESeqDataSetFromMatrix}}, \code{\link[DESeq2]{DESeq}}, \code{\link[S4Vectors]{DataFrame}}, \code{\link[tibble]{as_tibble}}
}
\author{
Wang Ningqi \href{mailto:2434066068@qq.com}{2434066068@qq.com}
}
