% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_master_table.R
\name{make_master_table}
\alias{make_master_table}
\title{Create input master table from metadata and feature tables for
longdat_disc() and longdat_cont()}
\usage{
make_master_table(
  metadata_table,
  feature_table,
  sample_ID,
  individual,
  keep_id = FALSE
)
}
\arguments{
\item{metadata_table}{A data frame whose columns consist of
sample identifiers (sample_ID), individual, time point and other meta data.
Each row corresponds to one sample_ID. Metadata table should have the same
number of rows as feature table does. Please avoid using characters that
don't belong to ASCII printable characters for the column names.}

\item{feature_table}{A data frame whose columns only consist of
 sample identifiers (sample_ID) and features
 (dependent variables, e.g. microbiome). Each row corresponds to
 one sample_ID. Please do not include any columns other than
 sample_ID and features. Please avoid using characters that
don't belong to ASCII printable characters for the column names.
Also, feature table should have the same number
 of rows as metadata table does.}

\item{sample_ID}{The name of the column which stores sample identifiers.
Please make sure that sample_IDs are unique for each sample, and that
metadata and feature tables have the same sample_IDs. If sample_IDs don't
match between the two tables, it will fail to join them together. This
should be a string, e.g. "Sample_ID"}

\item{individual}{The name of the column which stores individual information
in the metadata table. This should be a string, e.g. "Individual"}

\item{keep_id}{A boolean vector indicating whether keep sample_ID
column in the output master table. The default is FALSE.}
}
\value{
a data frame which complies with the required format of an input
data frame for longdat_disc() and longdat_cont().
}
\description{
Create input master table from metadata and feature tables for
longdat_disc() and longdat_cont()
}
\details{
This function joins metadata and feature tables by the sample_ID
 column. Users can create master tables compatible with the format of
 longdat_disc() and longdat_cont() input easily.This function outputs a
 master table with individual as the first column, followed by time point
 and other metadata, and then by feature columns.
}
\examples{
\dontrun{
test_master <- make_master_table(
metadata_table = LongDat_disc_metadata_table,
feature_table = LongDat_disc_feature_table,
sample_ID = "Sample_ID",
individual = "Individual")
}
}
