% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataProcessing.R
\name{alignmsbatch}
\alias{alignmsbatch}
\title{Align samples from an msbatch}
\usage{
alignmsbatch(
  msbatch,
  dmz = 5,
  drt = 30,
  minsamples,
  minsamplesfrac = 0.75,
  span = 0.4,
  parallel = FALSE,
  ncores
)
}
\arguments{
\item{msbatch}{msbatch obtained from the \link{setmsbatch} function.}

\item{dmz}{mass tolerance between peak groups in ppm.}

\item{drt}{maximum rt distance between peaks for alignment in seconds.}

\item{minsamples}{minimum number of samples represented in each cluster 
used for the alignment.}

\item{minsamplesfrac}{minimum samples fraction represented in each cluster 
used for the alignment. Used to calculate minsamples in case it is missing.}

\item{span}{span parameter for loess rt deviation smoothing.}

\item{parallel}{logical. If TRUE, parallel processing will be performed.}

\item{ncores}{number of cores to be used in case parallel is TRUE.}
}
\value{
aligned msbatch
}
\description{
Align samples from an msbatch
}
\examples{
\dontrun{
msbatch <- setmsbatch(msbatch)
}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@iislafe.es>
}
