% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineChains.R
\name{combineChains}
\alias{combineChains}
\title{Combine chain fragments that could belong to the same precursor.}
\usage{
combineChains(candidates, nchains, sn1, sn2, sn3, sn4)
}
\arguments{
\item{candidates}{candidates data frame. Output of \link{findCandidates}.}

\item{nchains}{number of chains of the targeted lipid class.}

\item{sn1}{list of chain fragments identified for sn1 position. Output of
\link{chainFrags}.}

\item{sn2}{list of chain fragments identified for sn2 position. Output of
\link{chainFrags}. If required.}

\item{sn3}{list of chain fragments identified for sn3 position. Output of
\link{chainFrags}. If required.}

\item{sn4}{list of chain fragments identified for sn4 position. Output of
\link{chainFrags}. If required.}
}
\value{
List of data frames with candidate chains structures.
}
\description{
It calculates combinations of chain fragments that sum up the same number of
carbons and double bounds as the precursor.
}
\examples{
\donttest{
dbs <- assignDB()

candidates <- findCandidates(MS1 = LipidMS::MS1_neg$peaklist,
db = dbs$pgdb, ppm = 10, rt = c(0, 2000), adducts = c("M-H"),
rttol = 10, rawData = MS1_neg$rawScans, coelCutoff = 0.8)

MSMS <- rbind(LipidMS::MSMS1_neg$peaklist, LipidMS::MSMS2_neg$peaklist)
rawData <- rbind(LipidMS::MS1_neg$rawScans, LipidMS::MSMS1_neg$rawScans,
LipidMS::MSMS2_neg$rawScans)
coelfrags <- coelutingFrags(candidates$RT, MSMS, rttol = 10, rawData = rawData,
coelCutoff = 0.8)

sn1 <- chainFrags(coelfrags, chainfrags = c("lysopg_M-H"), ppm = 10,
dbs = dbs)
sn2 <- chainFrags(coelfrags, chainfrags = c("fa_M-H"), ppm = 10, dbs = dbs)

chainsComb <- combineChains(candidates, nchains=2, sn1, sn2)

intConf <- checkIntensityRules(intrules = c("lysopg_sn1/lysopg_sn1"),
rates = c("2/1"), intrequired = c(T), nchains=2, chainsComb, sn1, sn2)
}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
