% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_reconstruction.R
\name{spectral_reconstruction}
\alias{spectral_reconstruction}
\title{Reconstruct spectral irradiance from sensor counts}
\usage{
spectral_reconstruction(
  sensor_channels,
  calibration_matrix,
  format = c("long", "wide")
)
}
\arguments{
\item{sensor_channels}{Named numeric vector or dataframe with
sensor readings. Names must match calibration matrix columns.}

\item{calibration_matrix}{Matrix or dataframe with sensor-named columns and
wavelength-indexed rows}

\item{format}{Output format: "long" (list of tibbles) or "wide" (dataframe)}
}
\value{
\itemize{
\item "long": List of tibbles (wavelength, irradiance)
\item "wide": Dataframe with wavelength columns and one row per spectrum
}
}
\description{
This function takes sensor data in the form of (normalized) counts and
reconstructs a spectral power distribution (SPD) through a calibration matrix.
The matrix takes the form of \verb{sensor channel x wavelength}, and the spectrum
results form a linear combination of \verb{counts x calibration-value} for any
wavelength in the matrix. Handles multiple sensor readings by returning a list of spectra
}
\details{
Please note that calibration matrices are not provided by LightLogR, but can
be provided by a wearable device manufacturer. Counts can be normalized with
the \code{\link[=normalize_counts]{normalize_counts()}} function, provided that the output also contains a
\code{gain} column.
}
\examples{
# Calibration matrix example
calib <- matrix(1:12, ncol=3, dimnames = list(400:403, c("R", "G", "B")))

# Named vector input
spectral_reconstruction(c(R=1, G=2, B=3), calib)

# Dataframe input
df <- data.frame(R=1, G=2, B=3, other_col=10)
spectral_reconstruction(dplyr::select(df, R:B), calib)

# Multiple spectra: as list columns
df <- data.frame(Measurement = c(1,2), R=c(1,2), G=c(2,4), B=c(3,6))
df <- 
df |> 
  dplyr::mutate(
      Spectrum = spectral_reconstruction(dplyr::pick(R:B), calib)
      )
df |> tidyr::unnest(Spectrum)

# Multiple spectra: as extended dataframes
df |> 
  dplyr::mutate(
      Spectrum = spectral_reconstruction(dplyr::pick(R:B), calib, "wide"))
}
\seealso{
Other Spectrum: 
\code{\link{normalize_counts}()},
\code{\link{spectral_integration}()}
}
\concept{Spectrum}
