% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_Timedata.R
\name{create_Timedata}
\alias{create_Timedata}
\title{Create a Time-of-Day column in the dataset}
\usage{
create_Timedata(
  dataset,
  Datetime.colname = Datetime,
  Time.data = Time.data,
  output.dataset = TRUE
)
}
\arguments{
\item{dataset}{A light logger dataset. Expects a \code{dataframe}. If not imported
by \link{LightLogR}, take care to choose a sensible variable for the
\code{Datetime.colname}.}

\item{Datetime.colname}{column name that contains the datetime. Defaults to
\code{"Datetime"} which is automatically correct for data imported with
\link{LightLogR}. Expects a \code{symbol}. Needs to be part of the \code{dataset}.}

\item{Time.data}{Name of the newly created column. Expects a \code{symbol}. The
default(\code{Time.data}) works well with other functions in \link{LightLogR}.}

\item{output.dataset}{should the output be a \code{data.frame} (Default \code{TRUE}) or
a vector with \code{hms} (\code{FALSE}) times? Expects a \code{logical} scalar.}
}
\value{
a \code{data.frame} object identical to \code{dataset} but with the added
column of Time-of-Day data, or a \code{vector} with the Time-of-Day-data
}
\description{
Create a Time-of-Day column in the dataset
}
\examples{
sample.data.environment \%>\% create_Timedata()
}
