% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{deathBenefit.linearDecreasing}
\alias{deathBenefit.linearDecreasing}
\title{Describes the death benefit of a linearly decreasing whole life insurance (after a possible deferall period)}
\usage{
deathBenefit.linearDecreasing(len, params, values)
}
\arguments{
\item{len}{The desired length of the Cash flow vector (can be shorter than
the policyPeriod, if q_x=1 before the end of the contract, e.g.
for life-long insurances)}

\item{params}{The full parameter set of the insurance contract (including
all inherited values from the tariff and the profit participation)}

\item{values}{The values calculated from the insurance contract so far}
}
\value{
vector of linearly decreasing benefits over the whole insurance coverage period
}
\description{
The death benefit will be the full sumInsured for the first year after the
deferral period and then decrease linearly to 0 at the end of the policyPeriod.
This can be used with the \code{deathBenefit} parameter for insurance
contracts, but should not be called directly.
}
