% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemfitbayesian.R
\name{itemfit_bayesian}
\alias{itemfit_bayesian}
\title{Bayesian parameter estimation of a test}
\usage{
itemfit_bayesian(data, dim, model = "2PL", EMepsilon = 1e-04,
  clusters = NULL, quad_tech = NULL, quad_points = NULL,
  individual_weights = as.numeric(c()), initial_values = NULL,
  noguessing = TRUE, verbose = TRUE, save_time = TRUE)
}
\arguments{
\item{data}{The matrix containing the answers of tested individuals}

\item{dim}{The dimensionality of the test}

\item{model}{"1PL", "2PL" or "3PL"}

\item{EMepsilon}{Convergence value to determine the accuracy of the test}

\item{clusters}{A vector with cluster per dimension}

\item{quad_tech}{A string with technique. "Gaussian" for Gaussian quadrature 
or "QMCEM" for Quasi-Monte Carlo quadrature. If NULL it's selected according to the model's dimension (QMCEM if dim>3).}

\item{quad_points}{Amount of quadrature points. If quadratura_technique is "Gaussian". It can be NULL}

\item{individual_weights}{A vector with Weights of the quadrature points.}

\item{initial_values}{A matrix with initial values for estimation process. Be sure about
dimension, model and consistency with data.}

\item{noguessing}{In 3PL model and dimension is greater than 1, If true, guessing parameter will not be estimated in zeta vector. Instead
c value will have a default initial value. Otherwise guessing parameter will be estimated with zeta vector.}

\item{verbose}{True for get information about estimation process in runtime. False in otherwise.}

\item{save_time}{True for save estimation time. False otherwise.}
}
\description{
Estimates the test parameters according to the Multidimensional Item Response Theory with
bayesian adjust for dichotomous data
}
\section{Model}{

\describe{
 Bayesian model is based in itemfit models. It has a \eqn{Q_{i}} function to optimize according parameters like in itemfit. However this model 
 is given by: 
 \deqn{Q_{i} = N * log(P_{\zeta_{i}}(\zeta_{i})) + \hat{Q_{i}}} 

 Where i index is referenced for items in test.

 Then, log posterior is given by:

 \deqn{log(P_{\zeta_{i}}(\zeta_{i})) = - \frac{N}{2} (\frac{(a_{1i} - \mu_{a1i})^2}{\sigma_{1i}^2} + \cdots + \frac{(a_{Di} - \mu_{aDi})^2}{\sigma_{Di}^2} + \frac{(d_{i} - \mu_{di})^2}{\sigma_{di}^2} + \frac{(c_{i} - \mu_{ci})^2}{\sigma_{ci}^2}) }

 Where a,d and c are parameters, D is the dimension of test. You can give the \eqn{\mu} values for each parameters through initial values matrix. In otherwise \eqn{\mu} will have default initial values value
 \eqn{\sigma^2} values are constant \eqn{\sigma_a^2 = 0.64}, \eqn{\sigma_d^2 = 4}, \eqn{\sigma_c^2 = 0.009}
}
}

