% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/wind.scale.R
\name{wind.scale}
\alias{wind.scale}
\alias{wind.scale.base}
\title{Wind Scaling U10 - exponential conversion to 10m wind speed}
\usage{
## Used for timeseries data in a data.frame
wind.scale(ts.data, wnd.z)

## Used for raw numeric data
wind.scale.base(wnd, wnd.z)
}
\arguments{
\item{ts.data}{Object of class data.frame containing a wnd column.}

\item{wnd.z}{height of anemometer (Units: meters)}

\item{wnd}{measured wind speed (Units: typically m s-1, but it is unit agnostic)}
}
\value{
## wind.scale
Returns a data frame with columns datetime and wnd_10 and the same number of rows as ts.data

## wind.scale.base
Returns a vector with the same length as wnd
}
\description{
Scale wind speed to standard U10 (10 meters) based on height of observations
}
\details{
This function transforms wind speed to the standard U10,
speed at 10 meters, based on the common exponential wind profile assumption.
wind.scale defaults to using the supplied wnd.z value. If wnd.z is not supplied,
it attempts to determine the anemometer height from the suffix of the header
(e.g., a header of wnd_3 would mean an anemometer height of 3 meters).
}
\examples{
wndSpeed <- c(5.1,6.3,6.3,5.2,7,7.2)
wndHeight <- 2

wind.scale.base(wndSpeed, wndHeight)
}
\author{
Aline Jaimes, Luke A. Winslow
}
\references{
Saucier, W. 2003. \emph{Principles of Meteorological Analysis}. Dover Publications. New York. p433
}
\seealso{
Models of gas flux \link{k.cole}, \link{k.crusius}, \link{k.macIntyre}, & \link{k.read}.
}

