% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary_functions.R
\name{stationary_p_sparse}
\alias{stationary_p_sparse}
\title{Sparse version of \code{\link{stationary_p}}}
\usage{
stationary_p_sparse(Gamma, t = NULL)
}
\arguments{
\item{Gamma}{sist of length L containing sparse transition probability matrices for one cycle.}

\item{t}{integer index of the time point in the cycle, for which to calculate the stationary distribution
If t is not provided, the function calculates all stationary distributions for each time point in the cycle.}
}
\value{
either the periodically stationary distribution at time t or all periodically stationary distributions.
}
\description{
This is function computes the periodically stationary distribution of a Markov chain given a list of L \strong{sparse} transition probability matrices.
Compatible with automatic differentiation by \code{RTMB}
}
\examples{
## periodic HSMM example (here the approximating tpm is sparse)
N = 2 # number of states
L = 24 # cycle length
# time-varying mean dwell times
Z = trigBasisExp(1:L) # trigonometric basis functions design matrix
beta = matrix(c(2, 2, 0.1, -0.1, -0.2, 0.2), nrow = 2)
Lambda = exp(cbind(1, Z) \%*\% t(beta))
sizes = c(20, 20) # approximating chain with 40 states
# state dwell-time distributions
dm = lapply(1:N, function(i) sapply(1:sizes[i]-1, dpois, lambda = Lambda[,i]))
omega = matrix(c(0,1,1,0), nrow = N, byrow = TRUE) # embedded t.p.m.

# calculating extended-state-space t.p.m.s
Gamma = tpm_phsmm(omega, dm)
# Periodically stationary distribution for specific time point
delta = stationary_p_sparse(Gamma, 4)

# All periodically stationary distributions
Delta = stationary_p_sparse(Gamma)
}
