% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary.R
\name{stationary}
\alias{stationary}
\title{Compute the stationary distribution of a homogeneous Markov chain}
\usage{
stationary(Gamma, tol = .Machine$double.eps)
}
\arguments{
\item{Gamma}{Transition probability matrix of dimension c(N,N)}

\item{tol}{The tolerance for detecting linear dependencies in the columns of Gamma. The default is .Machine$double.eps.}
}
\value{
Stationary distribution of the Markov chain with the given transition probability matrix
}
\description{
A homogeneous, finite state Markov chain that is irreducible and aperiodic converges to a unique stationary distribution, here called \eqn{\delta}.
As it is stationary, this distribution satisfies \cr \cr
\eqn{\delta \Gamma = \delta}, subject to \eqn{\sum_{j=1}^N \delta_j = 1}, \cr \cr
where \eqn{\Gamma} is the transition probability matrix. 
This function solves the linear system of equations above.
}
\examples{
Gamma = tpm(c(rep(-2,3), rep(-3,3)))
delta = stationary(Gamma)
}
