% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_mat.R
\name{corr_mat}
\alias{corr_mat}
\title{The Function for Constructing the Correlation Matrix in \code{LVGP} Package}
\usage{
corr_mat(X1, X2, phi_full)
}
\arguments{
\item{X1, X2}{Matrices containing the data points. The rows and columns of both \code{X1} and \code{X2} denote individual observation settings and dimension, respectively.}

\item{phi_full}{The vector storing all the scale (aka roughness) parameters of the correlation function. See \code{reference 1}.}
}
\value{
R The Correlation matrix with size \code{nrow(X1)}-by-\code{nrow(X2)}. See \href{https://en.wikipedia.org/wiki/Correlation_matrix}{here}.
}
\description{
Builds the correlation matrix given two datasets, and the type and parameters of the correlation function.
}
\note{
This function is \strong{NOT} exported once the LVGP package is loaded.
}
\examples{
# see the examples in the documentation of the function LVGP_fit.
}
\references{
\enumerate{
\item "A Latent Variable Approach to Gaussian Process Modeling with Qualitative and Quantitative Factors", Yichi Zhang, Siyu Tao, Wei Chen, and Daniel W. Apley (\href{https://arxiv.org/abs/1806.07504}{arXiv})
}
}
\seealso{
\code{\link[LVGP]{LVGP_fit}} to see how a GP model can be fitted to a training dataset.\cr
\code{\link[LVGP]{LVGP_predict}} to use the fitted LVGP model for prediction.\cr
\code{\link[LVGP]{LVGP_plot}} to plot the features of the fitted model.
}
