% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_lucid.R
\name{boot.lucid}
\alias{boot.lucid}
\title{Inference of LUCID model based on bootstrap resampling}
\usage{
boot.lucid(
  G,
  Z,
  Y,
  CoG = NULL,
  CoY = NULL,
  model,
  conf = 0.95,
  R = 100,
  ncpus = detectCores() - 1
)
}
\arguments{
\item{G}{Exposures, a numeric vector, matrix, or data frame. Categorical variable 
should be transformed into dummy variables. If a matrix or data frame, rows 
represent observations and columns correspond to variables.}

\item{Z}{Omics data, a numeric matrix or data frame. Rows correspond to observations
and columns correspond to variables.}

\item{Y}{Outcome, a numeric vector. Categorical variable is not allowed. Binary 
outcome should be coded as 0 and 1.}

\item{CoG}{Optional, covariates to be adjusted for estimating the latent cluster.
A numeric vector, matrix or data frame. Categorical variable should be transformed 
into dummy variables.}

\item{CoY}{Optional, covariates to be adjusted for estimating the association 
between latent cluster and the outcome. A numeric vector, matrix or data frame. 
Categorical variable should be transformed into dummy variables.}

\item{model}{A LUCID model fitted by \code{est.lucid}.}

\item{conf}{A numeric scalar between 0 and 1 to specify confidence level(s) 
of the required interval(s).}

\item{R}{An integer to specify number of bootstrap replicates for LUCID model.
If feasible, it is recommended to set R > 1000. However, the convergence speed 
of LUCID varies greatly depending on data. If it takes very long time to run
1000 replicates, it is recommend to set smaller values for R, such as 200.}

\item{ncpus}{Integer, number of processors to be used in parallel computation.}
}
\value{
A list, containing the following components:
\item{beta}{effect estimate for each exposure}
\item{mu}{cluster-specific mean for each omics feature}
\item{gamma}{effect estiamte for the association btween latent cluster and 
outcome}
\item{bootstrap}{The \code{boot} object returned by \code{boot:boot}}
}
\description{
Generate \code{R} bootstrap replicates of LUCID parameters and 
derive confidence interval (CI) base on bootstrap. Bootstrap replicates are 
generated based on nonparameteric resampling, implemented by \code{ordinary} 
method of code{boot::boot} function.
}
\examples{
\dontrun{
# use simulated data
G <- sim_data$G
Z <- sim_data$Z
Y_normal <- sim_data$Y_normal

# fit lucid model
fit1 <- est.lucid(G = G, Z = Z, Y = Y_normal, family = "normal", K = 2, 
seed = 1008)

# conduct bootstrap resampling
boot1 <- boot.lucid(G = G, Z = Z, Y = Y_normal, model = fit1, R = 100)

# check distribution for bootstrap replicates of the variable of interest
plot(boot1$bootstrap, 1)

# use 90\% CI
boot2 <- boot.lucid(G = G, Z = Z, Y = Y_normal, model = fit1, R = 100, conf = 0.9)
}
}
