% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkStrata.R
\name{checkStrata}
\alias{checkStrata}
\title{Checks all strata in py_table are contained in rate file}
\usage{
checkStrata(py_table, rateobj)
}
\arguments{
\item{py_table}{A stratified cohort created by \code{get_table}}

\item{rateobj}{A rate object created by \code{parseRate}}
}
\value{
A list containing:
\enumerate{
\item The py_table with strata removed not found in rateobj
\item The observations from py_table that were removed
}
}
\description{
Checks all strata in py_table are contained in rate file
}
\examples{
library(LTASR)
library(dplyr)
library(purrr)

#Import example person file
person <- person_example \%>\%
  mutate(dob = as.Date(dob, format='\%m/\%d/\%Y'),
         pybegin = as.Date(pybegin, format='\%m/\%d/\%Y'),
         dlo = as.Date(dlo, format='\%m/\%d/\%Y'))

#Import default rate object
rateobj <- us_119ucod_19602020

#Stratify person table
py_table <- get_table(person, rateobj)

#Check Strata are in rate file
checkStrata(py_table, rateobj)

}
