% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LSD.ellipsescatter.R
\name{ellipsescatter}
\alias{LSD.ellipsescatter}
\alias{ellipsescatter}
\title{Visualize subgroups of two-dimensional data assuming normal distributions}
\usage{
ellipsescatter(x, y, groups, colors = NULL, pch = 20, bgcol = "darkgrey",
  main = "ellipsescatter", xlab = NULL, ylab = NULL, scalesd = 1,
  level = 0.75, legend.cex = 1, location = "topright", ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{groups}{a list of indices or vector names to be plotted as groups (not necessarily all of x and y).}

\item{colors}{a character vector of R build-in colors corresponding to the chosen groups.}

\item{pch}{the plotting character (to be passed to plot).}

\item{bgcol}{a R build-in color for non-grouped points.}

\item{main}{title(s) of the plot, standard graphics parameter.}

\item{xlab}{x label, standard graphics parameter.}

\item{ylab}{y label, standard graphics parameter.}

\item{scalesd}{a numeric value giving the scaling factor for standard deviations in each dimension (defaults to 1).}

\item{level}{a numeric value (between 0 and 1) giving the confidence level of a pairwise confidence region.}

\item{legend.cex}{a numerical value giving the amount by which the added legend should be magnified relative to the default.}

\item{location}{the x and y co-ordinates to be used to position the legend (see 'xy.coords').}

\item{...}{additional parameters to be passed to points and plot.}
}
\description{
A scatterplot with additional colored ellipses based on a gaussianity assumption.
}
\examples{
x = c(rnorm(50),rnorm(100,2),rnorm(50,4))
y = (x + rnorm(200,0,0.8))*rep(c(1,4,1),c(50,100,50))
x = sign(x)*abs(x)^1.3

groups = list("Green" = 1:50,"Red" = 51:150,"Blue" = 151:200)
colors = c("darkgreen","darkred","darkblue")
ellipsescatter(x,y,groups,colors,location = "topleft")
}
\author{
Bjoern Schwalb
}
\seealso{
\code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\keyword{scatterplot}

