% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/confusion_stat.R
\name{confusion_stat}
\alias{confusion_stat}
\title{Display confusion or classification matrix following logistic regression using glm with binomial family.}
\format{\describe{
\item{x}{
The function has two arguments: predicted values, response values}
}}
\usage{
confusion_stat(pred=pred,obs=obs)
}
\arguments{
\item{pred}{Predicted values}

\item{obs}{Observed values}
}
\value{
confusion matrix
}
\description{
Provides a confusion matrix of classification statistics following logistic regression.
}
\note{
confusion_stat() must be loaded into memory in order to be effectve. As a function in LOGIT,
it is immediately available to a user.
}
\examples{
library(MASS)
library(LOGIT)
data(R84)
R84$cage <- R84$age - mean(R84$age)
R84$cdoc <- R84$docvis - mean(R84$docvis)
mylogit <- glm(outwork ~ cdoc + female + kids + cage + factor(edlevel),
family=binomial, data=R84)
mu <- predict(mylogit, type="response")
cutpoint<-ROCtest(mylogit, fold=10, type="Sensitivity")$cut
mu[mu>=cutpoint]<-1
mu[mu<cutpoint]<-0
confusion_stat(mu, R84$outwork)
}
\author{
Rafael de Souza, ELTE  University,  and Joseph M. Hilbe, Arizona State University
}
\references{
Hilbe, Joseph M. (2015), Practical Guide to Logistic Regression, Chapman & Hall/CRC.

Hilbe, Joseph M. (2009), Logistic Regression Models, Chapman & Hall/CRC.
}
\seealso{
\code{\link{glm}}
}
\keyword{models}

