% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind.anova_lmm.R
\name{rbind.anova_lmm}
\alias{rbind.anova_lmm}
\title{Linear Hypothesis Testing Across Linear Mixed Models}
\usage{
\method{rbind}{anova_lmm}(model, ..., name = NULL, sep = ": ")
}
\arguments{
\item{model}{a \code{anova_lmm} object (output of \code{anova} applied to a \code{lmm} object)}

\item{...}{possibly other \code{anova_lmm} objects}

\item{name}{[character vector or NULL] character used to identify each model in the output.
By default, use the name of the outcome of the model.}

\item{sep}{[character] character used to separate the outcome and the covariate when naming the tests.}
}
\description{
Linear hypothesis testing accross linear mixed model.
}
\examples{
## simulate data
set.seed(10)
dL <- sampleRem(1e2, n.times = 3, format = "long")

## estimate mixed models
e.lmm1 <- lmm(Y ~ X1+X2+X3, repetition = ~visit|id, data = dL,
              structure = "CS", df = FALSE)
e.lmm2 <- lmm(Y ~ X1+X8+X9, repetition = ~visit|id, data = dL,
              structure = "CS", df = FALSE)

## select null hypotheses
AAA <- anova(e.lmm1, ci = TRUE, effect = c("X1|X2,X3"="X1=0","X2|X1,X3"="X2=0"))
BBB <- anova(e.lmm2, ci = TRUE, effect = c("X1|X8,X9"="X1=0"))

## combine
ZZZ <- rbind(AAA,BBB)
summary(ZZZ)
}
