% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef}
\alias{coef}
\alias{coef.lmm}
\title{Extract Coefficients From a Linear Mixed Model}
\usage{
\method{coef}{lmm}(
  object,
  effects = NULL,
  p = NULL,
  transform.sigma = "none",
  transform.k = "none",
  transform.rho = "none",
  transform.names = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{lmm} object.}

\item{effects}{[character] Should all coefficients be output (\code{"all"}),
or only coefficients relative to the mean (\code{"mean"} or \code{"fixed"}),
or only coefficients relative to the variance structure (\code{"variance"}),
or only coefficients relative to the correlation structure (\code{"correlation"}).}

\item{p}{[numeric vector] value of the model coefficients to be used. Only relevant if differs from the fitted values.}

\item{transform.sigma}{[character] Transformation used on the variance coefficient for the reference level. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"} - see details.}

\item{transform.k}{[character] Transformation used on the variance coefficients relative to the other levels. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"}, \code{"sd"}, \code{"logsd"}, \code{"var"}, \code{"logvar"} - see details.}

\item{transform.rho}{[character] Transformation used on the correlation coefficients. One of \code{"none"}, \code{"atanh"}, \code{"cov"} - see details.}

\item{transform.names}{[logical] Should the name of the coefficients be updated to reflect the transformation that has been used?}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
A vector with the value of the model coefficients.
}
\description{
Extract coefficients from a linear mixed model.
}
\details{
\bold{transform.sigma}: \cr
\itemize{
\item \code{"none"} ouput residual standard error.
\item \code{"log"} ouput log-transformed residual standard error.
\item \code{"square"} ouput residual variance.
\item \code{"logsquare"} ouput log-transformed residual variance.
}

 \bold{transform.k}: \cr
\itemize{
\item \code{"none"} ouput ratio between the residual standard error of the current level and the reference level.
\item \code{"log"} ouput log-transformed ratio between the residual standard errors.
\item \code{"square"} ouput ratio between the residual variances.
\item \code{"logsquare"} ouput log-transformed ratio between the residual variances.
\item \code{"sd"} ouput residual standard error of the current level.
\item \code{"logsd"} ouput residual log-transformed standard error of the current level.
\item \code{"var"} ouput residual variance of the current level.
\item \code{"logvar"} ouput residual log-transformed variance of the current level.
}

 \bold{transform.rho}: \cr
\itemize{
\item \code{"none"} ouput correlation coefficient.
\item \code{"atanh"} ouput correlation coefficient after tangent hyperbolic transformation.
\item \code{"cov"} ouput covariance coefficient.
}

When using a (pure) compound symmetry covariance structure (\code{structure = "CS"}),
estimated random effects can be extracted by setting argument \code{effects} to \code{"ranef"}.
}
\examples{
## simulate data in the long format
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")

## fit linear mixed model
eUN.lmm <- lmm(Y ~ X1 + X2 + X5, repetition = ~visit|id, structure = "UN", data = dL, df = FALSE)

## output coefficients
coef(eUN.lmm)
coef(eUN.lmm, effects = "mean")
coef(eUN.lmm, transform.sigma = "none", transform.k = "none", transform.rho = "none")
}
