\name{normalize}
\alias{normalize}
\title{Normalize a matrix/vector to sum to one (probability simplex)}
\usage{
normalize(x, byrow = TRUE, tol = 1e-06)
}
\arguments{
  \item{x}{a numeric matrix(like object).}

  \item{byrow}{logical; if \code{TRUE} rows are normalized;
  otherwise columns.}

  \item{tol}{a tolerance level to set values \eqn{< tol} to
  \eqn{0} (after an initial normalization). Default:
  \code{tol=1e-6}}
}
\value{
  If \code{x} is a vector it returns the thresholded vector
  (see \code{\link{threshold}}) and normalized by its sum.
  If \code{x} is a matrix it works by column of by row
  (argument \code{byrow}).
}
\description{
  \code{normalize} projects a vector or matrix onto the
  probability simplex.

  If all entries (per row or column) get thresholded to
  \eqn{0} (since they are all negative to start with), then
  it sets the position of the maximum of \code{x} to
  \eqn{1} and leaves all other entries at \eqn{0}.
}
\examples{
print(normalize(c(1, 4, 2, 2, 10)))
print(normalize(c(-1, -2, -1)))
AA <- matrix(rnorm(12), ncol = 3)
print(normalize(AA, byrow = TRUE))
print(normalize(AA, byrow = FALSE))
}
\seealso{
  \code{\link{threshold}}
}
\keyword{array}
\keyword{manip}
