% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GICDeltaL_up.R
\name{getDeltaHL_up}
\alias{getDeltaHL_up}
\title{Estimation of the \code{H_delta} parameter with learning for upward detection in Gamma CUSUM control charts}
\usage{
getDeltaHL_up(
  n_I,
  alpha,
  beta,
  beta_ratio,
  H_plus,
  a,
  b,
  ARL_esp,
  replicates,
  N_init,
  N_final,
  known_alpha,
  K_l,
  delay,
  tau
)
}
\arguments{
\item{n_I}{Sample size in Phase I.}

\item{alpha}{Shape parameter of the Gamma distribution.}

\item{beta}{Scale parameter of the Gamma distribution.}

\item{beta_ratio}{Ratio between \code{beta} and its posterior estimate.}

\item{H_plus}{Initial limit of the CUSUM chart.}

\item{a}{Tolerance level for the expected ARL. (0 <= a < 1).}

\item{b}{Tolerance level for the expected ARL. (0 < b < 1)}

\item{ARL_esp}{Desired expected ARL value.}

\item{replicates}{Number of replications in the Monte Carlo simulation.}

\item{N_init}{Number of initial iterations for adjustment.}

\item{N_final}{Number of final iterations for averaging \code{H_delta}.}

\item{known_alpha}{\code{TRUE} if \code{alpha} is fixed, \code{FALSE} if it should be estimated.}

\item{K_l}{Secondary control threshold for parameter updating.}

\item{delay}{Number of observations before updating \code{beta0_est}.}

\item{tau}{Point in time where \code{beta} changes.}
}
\value{
A numeric value corresponding to the optimal \code{H_delta} estimated with learning for the upward CUSUM control chart.
}
\description{
This function calculates the optimal value of \code{H_delta} using a dynamic learning scheme
based on the \code{ARL_Clplus} function, iteratively adjusting \code{H_delta} to achieve an \strong{expected ARL}
with higher accuracy and adaptability.

Based on the methodology proposed by Madrid-Alvarez, García-Díaz, and Tercero-Gómez (2024),
this function allows adjusting \code{H_delta} in different sample size scenarios, ensuring
that the control chart progressively adapts to changes in the Gamma distribution.
\subsection{Features:}{
\itemize{
\item Implements Monte Carlo simulations to estimate \code{H_delta}.
\item Relies on parameter estimates obtained in Phase I.
\item Iteratively adjusts \code{H_delta} until the specified ARL is reached.
\item Incorporates a cautious learning mechanism to improve adjustment precision.
\item Displays the total execution time using \code{tictoc}.
}
}

\subsection{\strong{Recommendations}}{
\itemize{
\item This function is useful for estimating \code{H_delta} values when the sample size differs from the values reported in the reference article:

\strong{Madrid-Alvarez, H. M., García-Díaz, J. C., & Tercero-Gómez, V. G. (2024).}
\emph{A CUSUM control chart for the Gamma distribution with cautious parameter learning.}
Quality Engineering, 1-23.
\item \strong{The adjustment process is iterative and computationally intensive}, as execution time depends on the number of iterations (\code{N_init + N_final})
and the sample size (\code{n_I}).
\item It is recommended to define a proper convergence criterion to optimize execution time without compromising the accuracy of \code{H_delta} estimation.
\item For selecting values of \code{a}, \code{b}, \code{k_l}, \code{delay}, \code{tau}, and \code{H_plus}, consulting the reference article is recommended, as it provides specific strategies
for their calibration in different scenarios.
}
}
}
\examples{
\donttest{
getDeltaHL_up(
           n_I = 200, alpha = 1, beta = 1, beta_ratio = 2,
            H_plus = 6.8313, a = 0.1, b = 0.05, ARL_esp = 370,
             replicates = 100, N_init = 100, N_final = 500,
             known_alpha = TRUE, K_l = 2, delay = 25, tau = 1
            )
            }


}
