% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAPC.R
\name{SAPC}
\alias{SAPC}
\title{Apply the SAPC method to the Laplace factor model}
\usage{
SAPC(data, m, eta)
}
\arguments{
\item{data}{The data used in the SAPC analysis.}

\item{m}{is the number of principal component}

\item{eta}{is the proportion of online data to total data}
}
\value{
Asa,Dsa
}
\description{
This function calculates several metrics for the SAPC method,
including the estimated factor loadings and uniquenesses, and various
error metrics comparing the estimated matrices with the true matrices.
}
\examples{
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- SAPC(data, m, eta=0.1)
print(results)
}
