% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPC2.R
\name{PPC2}
\alias{PPC2}
\title{Apply the PPC method to the Laplace factor model}
\usage{
PPC2(data, m)
}
\arguments{
\item{data}{The total data set to be analyzed.}

\item{m}{The number of principal components.}
}
\value{
Apro,Dpro,Sigmahatpro
}
\description{
This function performs Projected Principal Component Analysis (PPC) on a given data set to reduce dimensionality. It calculates the estimated values for the loadings, specific variances, and the covariance matrix.
}
\examples{
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- PPC2(data, m)
print(results)
}
