% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDLErrorPropagation&bootstrapVariance.R
\name{LDLbootVrnc}
\alias{LDLbootVrnc}
\title{Calculate variance of LDL using bootstrapping.}
\usage{
LDLbootVrnc(CHOL, HDL, TG, sampleSize = length(CHOL), noOfReps = 1000, pb = F)
}
\arguments{
\item{CHOL}{A vector containing the cholesterol values to be used for LDL calculation.}

\item{HDL}{A vector containing the HDL values to be used for LDL calculation.}

\item{TG}{A vector containing the triglyceride values to be used for LDL calculation.
The three vectors (vecCHOL, vecHDL and vecG) must contain the same number of values}

\item{sampleSize}{Number of samples drawn uniformly and with replacement
from the three vectors. It cannot be larger than the sample size
(default=sample size).}

\item{noOfReps}{Number of bootstrap iterations.}

\item{pb}{Draw a text progress bar (defaut=FALSE)}
}
\value{
It returns a data table with four columns. The first
column contains the mean of the LDL values for each iteration. The second
column contains the median of each iteration.The third
column contains the variance and the fourth column contains
the CV of each iteration. It also returns the median of the "Mean", "Var"
and "CV" columns of the data table.
}
\description{
Function to calculate the variance of LDL using Bootstrapping.
}
\examples{
\dontrun{
LDLboostrpVar = LDLbootVrnc(sampleA$CHOL, sampleA$HDL, sampleA$TG)
}
}
