% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_TS.R
\name{package_LDA_TS}
\alias{package_LDA_TS}
\title{Package the output of LDA_TS}
\usage{
package_LDA_TS(LDAs, sel_LDA, TSs, sel_TSs)
}
\arguments{
\item{LDAs}{List (class: \code{LDA_set}) of LDA models (class: 
\code{LDA}), as returned by \code{\link{LDA_set}}.}

\item{sel_LDA}{A reduced version of \code{LDAs} that only includes the 
LDA model(s) selected by \code{\link{select_LDA}}. Still should be of
class \code{LDA_set}.}

\item{TSs}{Class \code{TS_on_LDA} list of results from \code{\link{TS}} 
applied for each model on each LDA model input, as returned by 
\code{\link{TS_on_LDA}}.}

\item{sel_TSs}{A reduced version of \code{TSs} (of class \code{TS_fit})
that only includes the TS model chosen via \code{\link{select_TS}}.}
}
\value{
Class \code{LDA_TS}-class object including all fitted models and 
  selected models specifically, ready to be returned from 
  \code{\link{LDA_TS}}.
}
\description{
Combine the objects returned by \code{\link{LDA_set}},
  \code{\link{select_LDA}}, \code{\link{TS_on_LDA}}, and
  \code{\link{select_TS}}, name them as elements of the list, and
  set the class of the list as \code{LDA_TS}, for the return from
  \code{\link{LDA_TS}}.
}
\examples{
\donttest{
  data(rodents)
  data <- rodents
  control <- LDA_TS_control()              
  dtt <- data$document_term_table
  dct <- data$document_covariate_table
  weights <- document_weights(dtt)
  LDAs <- LDA_set(dtt, 2, 1, control$LDA_set_control)
  sel_LDA <- select_LDA(LDAs, control$LDA_set_control)
  TSs <- TS_on_LDA(sel_LDA, dct, ~1, 1, "newmoon", weights,  
                   control$TS_control)
  sel_TSs <- select_TS(TSs, control$TS_control)
  package_LDA_TS(LDAs, sel_LDA, TSs, sel_TSs)
}
 
}
