% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overwrite_functions.R
\name{predict.LBBNN_Net}
\alias{predict.LBBNN_Net}
\title{Obtain predictions from the variational posterior of an \code{LBBNN model}}
\usage{
\method{predict}{LBBNN_Net}(object, mpm, newdata, draws, device = "cpu", link = NULL, ...)
}
\arguments{
\item{object}{A trained \code{LBBNN_Net} object}

\item{mpm}{logical, whether to use the median probability model.}

\item{newdata}{A \code{torch::dataloader} object containing the data with which to predict.}

\item{draws}{integer, the number of samples to draw from the posterior.}

\item{device}{character, device for computation (default = \code{"cpu"}).}

\item{link}{Optional link function to apply to the network output. Currently not implemented.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A \code{torch::torch_tensor}  of shape \code{(draws,N,C)} where \code{N} is the number of samples in \code{newdata}, and \code{C} the number of outputs.
}
\description{
Draw from the (variational) posterior distribution of a trained \code{LBBNN_Net} object.
}
\examples{
\donttest{ 
x<-torch::torch_randn(3,2) 
b <- torch::torch_rand(2)
y <- torch::torch_matmul(x,b)
train_data <- torch::tensor_dataset(x,y)
train_loader <- torch::dataloader(train_data,batch_size = 3,shuffle=FALSE)
problem<-'regression'
sizes <- c(2,1,1) 
inclusion_priors <-c(0.9,0.2) 
inclusion_inits <- matrix(rep(c(-10,10),2),nrow = 2,ncol = 2)
stds <- c(1.0,1.0)
model <- LBBNN_Net(problem,sizes,inclusion_priors,stds,inclusion_inits,flow = FALSE,
input_skip = TRUE)
train_LBBNN(epochs = 1,LBBNN = model, lr = 0.01,train_dl = train_loader)
predict(model,mpm = FALSE,newdata = train_loader,draws = 1)
}
}
