% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dshapebivr}
\alias{dshapebivr}
\title{Bivariate Kernel density estimation for data classified in polygons or shapes}
\usage{
dshapebivr(data, burnin = 2, samples = 5, adaptive = FALSE, shapefile,
  gridsize = 200)
}
\arguments{
\item{data}{matrix with at least 3 columns: x-coordinate, y-coordinate (i.e. center of polygon) and number of observations in area Optional fourth column: ID-Variable if area consists of more than 1 polygon}

\item{burnin}{burn-in sample size}

\item{samples}{sampling iteration size}

\item{adaptive}{TRUE for adaptive kernel density estimation}

\item{shapefile}{shapefile with number of polygons equal to nrow(data)}

\item{gridsize}{number of evaluation grid points}
}
\value{
The function returns a list object with the following objects (besides all input objects):
\item{\code{Mestimates}}{kde object containing the corrected density estimate}
\item{\code{gridx}}{Vector Grid of x-coordinates on which density is evaluated}
\item{\code{gridy}}{Vector Grid of y-coordinates on which density is evaluated}
\item{\code{resultDensity}}{Matrix with Estimated Density for each iteration}
\item{\code{resultX}}{Matrix of true latent values X estimates}
}
\description{
Bivariate Kernel density estimation for data classified in polygons or shapes
}

