% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/functions.R
\name{sim.Kernelheaping}
\alias{sim.Kernelheaping}
\title{Simulation of heaping correction method}
\usage{
sim.Kernelheaping(simRuns, n, distribution, rounds, rprobs, ...)
}
\arguments{
\item{simRuns}{number of simulations runs}

\item{n}{sample size}

\item{distribution}{name of the distribution where random sampling is available, e.g. "norm"}

\item{rounds}{rounding values}

\item{rprobs}{rounding probabilities (for Beta=0)}

\item{...}{additional attributes handed over to \code{createSim.Kernelheaping} or \code{dheaping}}
}
\value{
List of estimation results
}
\description{
Simulation of heaping correction method
}
\examples{
\dontrun{Sims1 <- sim.Kernelheaping(simRuns=2, n=500, distribution="norm",
rounds=c(1,10,100), rprobs=c(0.3,0.4,0.3), sd=100)}
}

