<!-- README.md is generated from README.Rmd. Please edit that file -->
KSD
---

### Overview

This package is an adaptation of Kernelized Stein Discrepancy, a discrepancy statistic for measuring differences between two probability distributions based on combination of Stein's method and reproducing kernel Hilbert space theory. It is based on "A Kernelized Stein Discrepancy for Goodness-of-fit Tests and Model Evaluation" by Liu, Lee, and Jordan, available at <http://arxiv.org/abs/1602.03253>.

### Main Components

#### KSD

The main function of this package is KSD, which estimates Kernelized Stein Discrepancy. Parameters include :

-   **x** Sample of size Num\_Instance x Num\_Dimension
-   **score\_q** Score funtion : takes x as input and output a column vector of size Num\_Instance X Dimension. User may use pryr package to pass in a function that only takes in dataset as parameter, or user may also pass in computed score for a given dataset.
-   **kernel** Type of kernel (default = 'rbf')
-   **width** Bandwidth of the kernel
-   **nboot** Bootstrap sample size

#### Examples and Demos

Other methods are also in this package, including various demos and examples.

KSD requires user to provide a score function to be used for computation. For example usage and exploration, a *gmm* class is provided in the pacakge, which allow test KSD using gaussian mixture model.

Consider the following examples :

1.  We define a gmm, generate random data using the model, and test the null hypothesis that the data comes from the model. Obviously, the result will depend on the model and the amount of added random noise.

``` r
# Pass in a dataset generated by Gaussian distribution,
# pass in computed score rather than score function

library(KSD)
library(pryr)
#> Warning: package 'pryr' was built under R version 3.2.5

model <- gmm()
X <- rgmm(model, n=100)
score_q = scorefunctiongmm(model=model, X=X)
result <- KSD(X,score_q=score_q)
result$p
#> [1] 0.899
```

1.  We follow similar pattern, but in this example, we use pryr library to define a score function like a function handle in matlab, in which we pass in model as part of the function.

``` r
# Pass in a dataset generated by Gaussian distribution,
# use pryr package to pass in score function
library(KSD)
library(pryr)
model <- gmm()
X <- rgmm(model, n=100)
score_q = pryr::partial(scorefunctiongmm, model=model)
result <- KSD(X,score_q=score_q)
result$p
#> [1] 0.899
```

#### Demos

Premade demos include the following (Note that these demos require additional libraries)

    demo_iris()
    demo_normal_performance()
    demo_simple_gaussian()
    demo_simple_gamma()
    demo_gmm()
    demo_gmm_multi()

A sample run of demo\_iris :

``` r
library(KSD)
library(datasets)
library(ggplot2)
#> Warning: package 'ggplot2' was built under R version 3.2.3
library(gridExtra)
#> Warning: package 'gridExtra' was built under R version 3.2.3
library(mclust)
#> Warning: package 'mclust' was built under R version 3.2.3
#> Package 'mclust' version 5.1
#> Type 'citation("mclust")' for citing this R package in publications.
library(pryr)

demo_iris()
#> [1] "Fitting GMM with 3 clusters"
#> [1] "Average p value : 0.366"
```

![](README-demoIris-1.png)<!-- -->

### Installation instructions

Currently, the code is available at <https://github.com/MinHyung-Kang/KSD/> More download options will be available after CRAN submission.

### Contact/Bug Reports

Minhyung(dot)Daniel(dot)Kang(at)gmail(dot)com
