% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.multiply.R
\name{xxt}
\alias{xxt}
\title{Calculate matrix multipication between a matrix and its
transpose for large data.}
\usage{
xxt(X, window.size = 5)
}
\arguments{
\item{X}{An input matrix to be processed.}

\item{window.size}{The window size of matrices to be devided. The default
value is 5.}
}
\value{
The multiplication matrix of \code{X.t(X)}.
}
\description{
Calculate matrix multiplication using "divide and
conquer technique", which accelerates the computation to be faster.
}
\examples{


#Use the example files embedded in the package.
X <-matrix(runif(100), ncol=20)
R1  <- xxt(X)

#Show the result (R1)
print(R1)
R2 <- X \%*\% t(X)

#Show the result (R2)
print(R2)



}
