% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkhs.r
\docType{class}
\name{rkhs}
\alias{rkhs}
\title{The 'rkhs' class object}
\format{
\code{\link{R6Class}} object.
}
\value{
an  \code{\link{R6Class}} object which can be used for doing interpolation using reproducing kernel Hilbert space.
}
\description{
This class provide the interpolation methods using reproducing kernel Hilbert space.
}
\section{Methods}{

\describe{
  \item{\code{predict()}}{This method is used to make prediction on given time points} 	
  \item{\code{skcross()}}{This method is used to do cross-validation to estimate the weighting parameter lambda of L^2 norm.} }
}

\examples{
\dontshow{
  ##examples for checks: executable in < 5 sec together with the examples above not shown to users
  ### define ode 
  toy_fun = function(t,x,par_ode){
       alpha=par_ode[1]
      as.matrix( c( -alpha*x[1]) )
   }

   toy_grlNODE= function(par,grad_ode,y_p,z_p) { 
       alpha = par[1]
       dres= c(0)
       dres[1] = sum( 2*( z_p-grad_ode)*y_p*alpha ) #sum( -2*( z_p[1,2:lm]-dz1)*z1*alpha ) 
       dres
   }

  t_no = c(0.1,1,2,3,4,8)
  n_o = length(t_no)   
  y_no =  matrix( c(exp(-t_no)),ncol=1  )
  ######################## create and initialise ode object #########################################
 init_par = rep(c(0.1))
 init_yode = t(y_no)
 init_t = t_no

 kkk = ode$new(1,fun=toy_fun,grfun=toy_grlNODE,t=init_t,ode_par= init_par, y_ode=init_yode )

 ##### using kernel ridge regression to learn the interpolation of the noisy observation

 initlen = 1
 aker = RBF$new(initlen)
 bbb = rkhs$new(t(y_no)[1,],t_no,rep(1,n_o),1,aker)
## optimise lambda by cross-validation
## initial value of lambda
 initlam = 2
 bbb$skcross( initlam ) 

}
\dontrun{
require(mvtnorm)
noise = 0.1  ## set the variance of noise
SEED = 19537
set.seed(SEED)
## Define ode function, we use lotka-volterra model in this example. 
## we have two ode states x[1], x[2] and four ode parameters alpha, beta, gamma and delta.
LV_fun = function(t,x,par_ode){
  alpha=par_ode[1]
  beta=par_ode[2]
  gamma=par_ode[3]
  delta=par_ode[4]
  as.matrix( c( alpha*x[1]-beta*x[2]*x[1] , -gamma*x[2]+delta*x[1]*x[2] ) )
}
## Define the gradient of ode function against ode parameters 
## df/dalpha,  df/dbeta, df/dgamma, df/ddelta where f is the differential equation.
LV_grlNODE= function(par,grad_ode,y_p,z_p) { 
alpha = par[1]; beta= par[2]; gamma = par[3]; delta = par[4]
dres= c(0)
dres[1] = sum( -2*( z_p[1,]-grad_ode[1,])*y_p[1,]*alpha ) 
dres[2] = sum( 2*( z_p[1,]-grad_ode[1,])*y_p[2,]*y_p[1,]*beta)
dres[3] = sum( 2*( z_p[2,]-grad_ode[2,])*gamma*y_p[2,] )
dres[4] = sum( -2*( z_p[2,]-grad_ode[2,])*y_p[2,]*y_p[1,]*delta)
dres
}

## create a ode class object
kkk0 = ode$new(2,fun=LV_fun,grfun=LV_grlNODE)
## set the initial values for each state at time zero.
xinit = as.matrix(c(0.5,1))
## set the time interval for the ode numerical solver.
tinterv = c(0,6)
## solve the ode numerically using predefined ode parameters. alpha=1, beta=1, gamma=4, delta=1.
kkk0$solve_ode(c(1,1,4,1),xinit,tinterv) 

## Add noise to the numerical solution of the ode model and use it as the noisy observation.
n_o = max( dim( kkk0$y_ode) )
t_no = kkk0$t
y_no =  t(kkk0$y_ode) + rmvnorm(n_o,c(0,0),noise*diag(2))

## Create a ode class object by using the simulation data we created from the ode numerical solver.
## If users have experiment data, they can replace the simulation data with the experiment data.
## Set initial value of ode parameters.
init_par = rep(c(0.1),4)
init_yode = t(y_no)
init_t = t_no
kkk = ode$new(1,fun=LV_fun,grfun=LV_grlNODE,t=init_t,ode_par= init_par, y_ode=init_yode )

## The following examples with CPU or elapsed time > 5s
####### rkhs interpolation for the 1st state of ode using 'rbf' kernel
### set initial value of length scale of rbf kernel
initlen = 1
aker = RBF$new(initlen)
bbb = rkhs$new(t(y_no)[1,],t_no,rep(1,n_o),1,aker)
## optimise lambda by cross-validation
## initial value of lambda
initlam = 2
bbb$skcross( initlam ) 

## make prediction using the 'predict()' method of 'rkhs' class and plot against the time.
plot(t_no,bbb$predict()$pred)
}
}
\author{
Mu Niu, \email{mu.niu@glasgow.ac.uk}
}
\keyword{data}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{y}}{matrix(of size n_s*n_o) containing observation.}

\item{\code{t}}{vector(of length n_o) containing time points for observation.}

\item{\code{b}}{vector(of length n_o) containing coefficients of kernel or basis functions.}

\item{\code{lambda}}{scalar containing the weighting parameter for L2 norm of the reproducing kernel Hilbert space.}

\item{\code{ker}}{kernel class object containing kernel.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{rkhs$new()}}
\item \href{#method-greet}{\code{rkhs$greet()}}
\item \href{#method-showker}{\code{rkhs$showker()}}
\item \href{#method-predict}{\code{rkhs$predict()}}
\item \href{#method-predictT}{\code{rkhs$predictT()}}
\item \href{#method-lossRK}{\code{rkhs$lossRK()}}
\item \href{#method-grlossRK}{\code{rkhs$grlossRK()}}
\item \href{#method-numgrad}{\code{rkhs$numgrad()}}
\item \href{#method-skcross}{\code{rkhs$skcross()}}
\item \href{#method-mkcross}{\code{rkhs$mkcross()}}
\item \href{#method-loss11}{\code{rkhs$loss11()}}
\item \href{#method-grloss11}{\code{rkhs$grloss11()}}
\item \href{#method-clone}{\code{rkhs$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$new(y = NULL, t = NULL, b = NULL, lambda = NULL, ker = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-greet"></a>}}
\if{latex}{\out{\hypertarget{method-greet}{}}}
\subsection{Method \code{greet()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$greet()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-showker"></a>}}
\if{latex}{\out{\hypertarget{method-showker}{}}}
\subsection{Method \code{showker()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$showker()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$predict()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predictT"></a>}}
\if{latex}{\out{\hypertarget{method-predictT}{}}}
\subsection{Method \code{predictT()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$predictT(testT)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-lossRK"></a>}}
\if{latex}{\out{\hypertarget{method-lossRK}{}}}
\subsection{Method \code{lossRK()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$lossRK(par, tl1, y_d, jitter)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-grlossRK"></a>}}
\if{latex}{\out{\hypertarget{method-grlossRK}{}}}
\subsection{Method \code{grlossRK()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$grlossRK(par, tl1, y_d, jitter)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-numgrad"></a>}}
\if{latex}{\out{\hypertarget{method-numgrad}{}}}
\subsection{Method \code{numgrad()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$numgrad(par, tl1, y_d, jitter)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-skcross"></a>}}
\if{latex}{\out{\hypertarget{method-skcross}{}}}
\subsection{Method \code{skcross()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$skcross(init, bounded)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mkcross"></a>}}
\if{latex}{\out{\hypertarget{method-mkcross}{}}}
\subsection{Method \code{mkcross()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$mkcross(init)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-loss11"></a>}}
\if{latex}{\out{\hypertarget{method-loss11}{}}}
\subsection{Method \code{loss11()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$loss11(par, tl1, y_d, jitter)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-grloss11"></a>}}
\if{latex}{\out{\hypertarget{method-grloss11}{}}}
\subsection{Method \code{grloss11()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$grloss11(par, tl1, y_d, jitter)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkhs$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
