% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SSModel.R
\name{plot.SSModel}
\alias{plot.SSModel}
\title{Diagnostic Plots of State Space Models}
\usage{
\method{plot}{SSModel}(x, nsim = 0, zerotol = 0, expected = FALSE, ...)
}
\arguments{
\item{x}{Object of class \code{SSModel}.}

\item{nsim}{The number of independent samples used in importance sampling.
Only used for non-Gaussian model. Default is 0, which computes the
approximating Gaussian model by \code{\link{approxSSM}} and performs the
usual Gaussian filtering/smoothing so that the smoothed state estimates
equals to the conditional mode of \eqn{p(\alpha_t|y)}{p(\alpha[t]|y)}.
In case of \code{nsim = 0}, the mean estimates and their variances are computed using
the Delta method (ignoring the covariance terms).}

\item{zerotol}{Tolerance parameter for positivity checking in standardization. Default is zero. 
The values of D <= zerotol * max(D, 0) are deemed to zero.}

\item{expected}{Logical value defining the approximation of H_t in case of Gamma 
and negative binomial distribution. Default is \code{FALSE} which matches the 
algorithm of Durbin & Koopman (1997), whereas \code{TRUE} uses the expected value
of observations in the equations, leading to results which match with \code{glm} (where applicable).
The latter case was the default behaviour of KFAS before version 1.3.8.
Essentially this is the difference between observed and expected information.}

\item{...}{Ignored.}
}
\description{
Diagnostic plots based on standardized residuals for objects of class \code{SSModel}.
}
\examples{
modelNile <- SSModel(Nile ~ SSMtrend(1, Q = list(matrix(NA))), H = matrix(NA))
modelNile <- fitSSM(inits = c(log(var(Nile)),log(var(Nile))), model = modelNile,
 method = "BFGS")$model

if (interactive()) {
  plot(modelNile)
}
}
