% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{densplot}
\alias{densplot}
\alias{densplot.mcmc.list}
\alias{densplot.JointAI}
\title{Plot the posterior density from object of class JointAI}
\usage{
densplot(object, ...)

\method{densplot}{mcmc.list}(object, start = NULL, end = NULL,
  thin = NULL, ...)

\method{densplot}{JointAI}(object, start = NULL, end = NULL,
  thin = NULL, subset = c(analysis_main = TRUE),
  exclude_chains = NULL, vlines = NULL, nrow = NULL, ncol = NULL,
  joined = FALSE, use_ggplot = FALSE, keep_aux = FALSE,
  warn = TRUE, mess = TRUE, ...)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{...}{additional parameters passed to \code{\link[graphics]{plot}}}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{subset}{subset of parameters/variables/nodes (columns in the MCMC sample).
Uses the same logic as the argument \code{monitor_params} in
\code{\link[JointAI:model_imp]{*_imp}}.}

\item{exclude_chains}{optional vector of the index numbers of chains that should be excluded}

\item{vlines}{list, where each element is a named list of parameters that
can be passed to \code{\link[graphics]{abline}} to create
vertical lines.
Each of the list elements needs to contain at least
\code{v = <x location>}, where <x location> is a vector of the
same length as the number of plots (see examples).}

\item{nrow}{optional number of rows and columns in the plot layout;
automatically chosen if unspecified}

\item{ncol}{optional number of rows and columns in the plot layout;
automatically chosen if unspecified}

\item{joined}{logical; should the chains be combined before plotting?}

\item{use_ggplot}{logical; Should ggplot be used instead of the base graphics?}

\item{keep_aux}{logical; Should constant effects of auxiliary variables be kept in the output?}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}. (Note: this applies only to warnings
given directly by \strong{JointAI}.)}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}. (Note: this applies only to messages
given directly by \strong{JointAI}.)}
}
\description{
The function plots a set of densities (per chain and coefficient) from
the MCMC sample of an object of class "JointAI".
}
\examples{

# fit a JointAI object:
mod <- lm_imp(y ~ C1 + C2 + M1, data = wideDF, n.iter = 100)

# Example 1: basic densityplot
densplot(mod)
densplot(mod, exclude_chains = 2)


# Example 2: use vlines to mark zero
densplot(mod, col = c("darkred", "darkblue", "darkgreen"),
         vlines = list(list(v = rep(0, nrow(summary(mod)$stats)),
                            col = grey(0.8))))


# Example 3: use vlines to visualize the posterior mean and 2.5\% and 97.5\% quantiles
densplot(mod, vlines = list(list(v = summary(mod)$stats[, "Mean"], lty = 1, lwd = 2),
                            list(v = summary(mod)$stats[, "2.5\%"], lty = 2),
                            list(v = summary(mod)$stats[, "97.5\%"], lty = 2)))


# Example 4: ggplot version
densplot(mod, use_ggplot = TRUE)


# Example 5: changing how the ggplot version looks (using standard ggplot syntax)
library(ggplot2)

densplot(mod, use_ggplot = TRUE) +
  xlab("value") +
  theme(legend.position = 'bottom') +
  scale_color_brewer(palette = 'Dark2', name = 'chain')


}
\seealso{
The vignette \href{https://nerler.github.io/JointAI/articles/SelectingParameters.html}{Parameter Selection}
contains some examples how to specify the argument \code{subset}.
}
