#' Fitted object of class 'JointAI'
#'
#' An object returned by one of the main functions \code{\link[JointAI:model_imp]{*_imp}}.
#'
#' @name JointAIObject
#'
#' @return
#' \item{\code{analysis_type}}{\code{lm}, \code{glm}, \code{clm}, \code{lme},
#'                             \code{glme}, \code{clmm}, \code{survreg} or
#'                             \code{coxph} with attributes
#'                             \code{family} and \code{link}}
#' \item{\code{data}}{the original (incomplete) dataset}
#' \item{\code{models}}{named vector specifying the models used for longitudinal
#'                      and incomplete covariates}
#' \item{\code{fixed}}{supplied fixed effects formula}
#' \item{\code{random}}{supplied random effects formula}
#' \item{\code{Mlist}}{a list: containing the data, split up into
#'       \itemize{
#'         \item outcome (\code{y})
#'         \item event indicator for survival outcomes (\code{event})
#'         \item cross-sectional main effects (\code{Xc})
#'         \item cross-sectional interactions (\code{Xic})
#'         \item longitudinal main effects (\code{Xl})
#'         \item longitudinal interactions (\code{Xil})
#'         \item categorical cross-sectional incomplete variables (\code{Xcat})
#'         \item categorical longitudinal variables (\code{Xlcat})
#'         \item transformed cross-sectional variables (\code{Xtrafo})
#'         \item transformed longitudinal variables (\code{Xltrafo})
#'         \item random effects design matrix (\code{Z})
#'       }
#'       and other important specifications:
#'       \itemize{
#'         \item a list naming which columns of the above matrices are
#'               covariates in the analysis model (\code{cols_main})
#'         \item a list giving the names of the covariates in the analysis
#'               model per matrix (\code{names_main})
#'         \item specification for transformations (\code{trafos})
#'         \item specification for hierarchical centering (\code{hc_list})
#'         \item reference values and dummies for categorical variables (\code{refs})
#'         \item formula specifying auxiliary variables (\code{auxvars})
#'         \item grouping specification (\code{groups})
#'         \item the vector of variables to be scaled (\code{scale_vars})
#'         \item updated fixed effects structure (\code{fixed2})
#'         \item the number of categories if the outcome of the analysis model
#'               is categorical (\code{ncat})
#'         \item the number of subjects (\code{N})
#'         \item whether posterior predictive checks are be enabled \code{ppc} (not yet used)
#'         \item whether ridge shrinkage priors should are used for the
#'               regression coefficients of the analysis model (\code{ridge})
#'         \item the number of random effects (\code{nranef})
#'       }}
#' \item{\code{K}}{matrix specifying the indices of the regression coefficients
#' that are related to different parts of the model}
#' \item{\code{K_imp}}{matrix specifying the indices of regression coefficients
#' for the imputation models relating to different covariates}
#' \item{\code{mcmc_settings}}{a list with elements
#'      \describe{
#'      \item{\code{modelfile}}{name and path of JAGS model file}
#'      \item{\code{n.chains}}{number of MCMC chains}
#'      \item{\code{n.adapt}}{number of iterations in the adaptive phase}
#'      \item{\code{n.iter}}{number of iterations in the MCMC sample}
#'      \item{\code{variable.names}}{monitored nodes}
#'      \item{\code{thin}}{thinning of the MCMC sample}
#'      \item{\code{inits}}{a list containing the initial values that were passed to \strong{rjags}}
#'      \item{\code{parallel}}{whether parallel sampling was used}
#'      \item{\code{n.cores}}{how many cores were used in parallel sampling}
#'      }}
#' \item{\code{monitor_params}}{the list of parameter groups to be monitored}
#' \item{\code{data_list}}{list with data that was passed to \strong{rjags}}
#' \item{\code{scale_pars}}{matrix with parameters used to center and scale the continuous variables}
#' \item{\code{hyperpars}}{a list containing the values of the hyperparameters used}
#' \item{\code{imp_par_list}}{a list with parameters used to write the imputation model syntax}
#' \item{\code{model}}{JAGS model}
#' \item{\code{sample}}{MCMC sample on the sampling scale (included only if \code{keep_scaled_sample = TRUE})}
#' \item{\code{MCMC}}{MCMC sample, scaled back to the scale of the data}
#' \item{\code{time}}{the computational time used for the sampling (adaptive phase + sampling)}
#' \item{\code{fitted.values}}{fitted (or predicted) values (if available)}
#' \item{\code{residuals}}{residuals (if available)}
#' \item{\code{call}}{the original call}
#'

NULL
