/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.GUI;

import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.omegahat.Environment.GUI.ClassTreeViewer;
import org.omegahat.Environment.GUI.ClassViewer;
import org.omegahat.Environment.GUI.TabbedElementContainer;
import org.omegahat.Environment.Interpreter.BasicEvaluator;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Tools.ClassList.ClassList;
import org.omegahat.Environment.Tools.ClassList.ClassLocator;
import org.omegahat.Environment.Utils.ListListener;
import org.omegahat.Environment.Utils.OrderedListEvent;
import org.omegahat.Environment.Utils.OrderedTable;

public class ClassPathViewer
extends TabbedElementContainer
implements ListListener {
    protected boolean showAllLists = true;

    public ClassPathViewer(Evaluator evaluator) {
        this(evaluator, true);
    }

    public ClassPathViewer(Evaluator evaluator, boolean bl) {
        super(evaluator, false);
        this.showAllLists = bl;
        this.make();
    }

    public void addSelectionListener(ListSelectionListener listSelectionListener) {
        int n = this.elementCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getElement(n2);
            ((ClassViewer)component).listView().addListSelectionListener(listSelectionListener);
            ++n2;
        }
    }

    public void assignPerformed(OrderedListEvent orderedListEvent) {
        OrderedTable orderedTable = (OrderedTable)orderedListEvent.getSource();
        if (orderedListEvent.index() > -1) {
            Object e = orderedTable.orderedKeys().elementAt(orderedListEvent.index());
            this.addElement(e, orderedTable.size() - 1);
        } else {
            System.err.println("Bug in ordered table? " + orderedListEvent.value());
        }
    }

    public String getName(Object object) {
        return ((File)object).getName();
    }

    public boolean make() {
        boolean bl = false;
        if (this.showAllLists) {
            bl = this.make(((BasicEvaluator)this.evaluator()).localClasses().orderedKeys().elements());
            System.err.println("Adding listener");
            ((BasicEvaluator)this.evaluator()).localClasses().addListListener(this);
        }
        bl = this.make(((BasicEvaluator)this.evaluator()).classLists().orderedKeys().elements());
        return bl;
    }

    public Component makeElement(Object object) {
        BasicEvaluator basicEvaluator = (BasicEvaluator)this.evaluator();
        JComponent jComponent = null;
        if (basicEvaluator.classLists().containsKey(object)) {
            jComponent = new JScrollPane(new ClassTreeViewer((ClassList)basicEvaluator.classLists().get(object)));
        } else if (basicEvaluator.localClasses().containsKey(object)) {
            jComponent = new ClassTreeViewer((ClassList)basicEvaluator.localClasses().get(object));
        }
        return jComponent;
    }

    public int merge(ClassLocator classLocator) {
        return this.add(classLocator.orderedKeys().elements());
    }

    public void removePerformed(OrderedListEvent orderedListEvent) {
    }
}

