% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{earthquake_station_sf}
\alias{earthquake_station_sf}
\title{Earthquake Observation Stations in Japan}
\format{
An sf object with 671 observations and 7 variables:
\describe{
  \item{prefecture}{Name of the prefecture (character)}
  \item{area}{Area within the prefecture (character)}
  \item{station_name}{Name of the observation station (character)}
  \item{address}{Physical address of the station (character)}
  \item{observation_begin}{Start date of observation (character)}
  \item{observation_end}{End date of observation, if available (character)}
  \item{geometry}{XY coordinates of the station (sf geometry column)}
}
}
\source{
Data taken from the jmastats package version 0.3.0
}
\usage{
data(earthquake_station_sf)
}
\description{
This dataset, earthquake_station_sf, is a spatial features (sf) tibble containing information about
671 earthquake observation stations managed by the Japan Meteorological Agency.
It includes details such as the prefecture, area, station name, address, and observation period.
}
\details{
The dataset name has been kept as 'earthquake_station_sf' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
JapanAPIs package and assists users in identifying its specific characteristics.
The suffix 'sf' indicates that the dataset is a spatial features object. The original content has not been modified
in any way.
}
