% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{SEMSummary.fit}
\alias{SEMSummary.fit}
\title{Summary Statistics for a SEM Analysis}
\usage{
SEMSummary.fit(
  formula,
  data,
  use = c("fiml", "pairwise.complete.obs", "complete.obs")
)
}
\arguments{
\item{formula}{A formula of the variables to be used in the analysis.
See the \sQuote{details} section for more information.}

\item{data}{A data frame, matrix, or list containing the variables
used in the formula.  This is a required argument.}

\item{use}{A character vector of how to handle missing data. Defaults to \dQuote{fiml}.}
}
\value{
A list with S3 class \dQuote{SEMSummary}
  \item{names}{A character vector containing the variable names.}
  \item{n}{An integer vector of the length of each variable used
    (this includes available and missing data).}
  \item{nmissing}{An integer vector of the number of missing values in each variable.}
  \item{mu}{A vector of the arithmetic means of each variable (on complete data).}
  \item{stdev}{A numeric vector of the standard deviations of each variable (on complete data).}
  \item{Sigma}{The numeric covariance matrix for all variables.}
  \item{sSigma}{The numeric correlation matrix for all variables.}
  \item{coverage}{A numeric matrix giving the percentage (technically decimal)
    of information available for each pairwise covariance/correlation.}
  \item{pvalue}{The two-sided p values for the correlation matrix. Pairwise present N
    used to calculate degrees of freedom.}
}
\description{
This is a low level fitting function, for SEMSummary.
}
\seealso{
\code{\link{SEMSummary}}
}
\keyword{multivariate}
