% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ninds}
\alias{ninds}
\title{NINDS rt-PA stroke trial data}
\format{
This data frame contains the following columns:

  \describe{
  
  \item{\code{ID}}{patient identifier.}

  \item{\code{Y}}{Acute ischemic stroke in an ordinal scale. Coded as \code{1} = no symptoms or no significant disability despite symptoms;
  \code{2} = slight disability; \code{3} = moderate disability or moderately severe disability; \code{4} = severe disability or dead.}
  
  \item{\code{intcpt_RE}}{a column of 1's for model setup as a random intercept covariate.}
  
  \item{\code{smlves_NP}}{small vessel occlusive disease as a non-proportional odds covariate.}
  
  \item{\code{lvORcs_NP}}{large vessel atherosclerosis / cardioembolic stroke as a non-proportional odds covariate. }
  
  \item{\code{group}}{treatment group indicator.}
  
  \item{\code{time3}}{dummy variable to indicate 3 months of follow-up.}
  
  \item{\code{time6}}{dummy variable to indicate 6 months of follow-up.}
  
  \item{\code{time12}}{dummy variable to indicate 12 months of follow-up.}
  
  \item{\code{mrkprior}}{modified Rankin scale prior stroke onset.}
  
  \item{\code{smlves}}{small vessel occlusive disease as a proportional odds covariate.}
  
  \item{\code{lvORcs}}{large vessel atherosclerosis / cardioembolic stroke as a proportional odds covariate.}
  
  \item{\code{smlves.group}}{interaction term between \code{smlves} and \code{group}.}
  
  \item{\code{lvORcs.group}}{interaction term between \code{lvORcs} and \code{group}.}
  
  \item{\code{surv}}{time to drop out or remaining in severe disability.}
  
  \item{\code{comprisk}}{event indicator. Coded as \code{0} = censored; \code{1} = drop out; 
  \code{2} = remaining in severe disability.}
  
  }
}
\usage{
data(ninds)
}
\description{
The \code{ninds} data frame has 1906 rows and 16 columns.
}
\references{
Li, Ning, et al. "Joint modeling of longitudinal ordinal data and competing risks survival 
times and analysis of the NINDS rt-PA stroke trial." Statistics in medicine 29.5 (2010): 
546-557.
}
\keyword{datasets}
