% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_tree_model.R
\name{irtree_model}
\alias{irtree_model}
\title{ItemResponseTrees model syntax}
\usage{
irtree_model(model = NULL)
}
\arguments{
\item{model}{String with a specific structure as described below.}
}
\value{
List of class \code{irtree_model}. It contains the information extracted
from \code{model}. Side note: The returned list contains an element
\code{mappping_matrix} that contains the pseudoitems. This information is
instructive, and it might be used as an input to the \code{dendrify()}
function of the irtrees package.
}
\description{
The ItemResponseTrees model syntax describes the statistical model. The
function \code{irtree_model()} turns a user-defined model string into an object of
class \code{irtree_model} that represents the full model as needed by the package.
}
\section{Overview of the Model Syntax}{


\enumerate{
\item The \code{model} string must contain at least the sections \strong{IRT},
\strong{Class}, and (if class is tree) \strong{Equations}.
\item Section headings must appear on a separate line ending with a colon (:).
\item The model may contain empty lines and commented lines, which begin
with \verb{#} (do not use inline comments).
\item Line breaks are only allowed in section \strong{IRT}.
}
Details for all the required and optional sections of the \code{model} string are
given in the following.
\subsection{Equations}{

The \code{model} must contain a section with heading \strong{Equations} if \strong{Class} is
Tree.
Therein, the model equations are described.
They have a structure similar to \code{Cat = p1*(1-p2)}, where \code{Cat} is any
observed response category in the data set, and where \code{p1} is a freely
chosen name of a parameter.
These names must match the names of the latent variables in the section
\strong{IRT} (combined with \strong{Constraints} if specified).

If you prefer to work with pseudo-items, \code{\link[=irtree_create_template]{irtree_create_template()}} can
generate the equations for you.

The equations may contain only products and not sums.
That is, it is not possible to estimate genuine mixture models as, for
example, in the package \href{https://github.com/hplieninger/mpt2irt}{mpt2irt}.

Each equation must appear on a separate, non-broken line. For example:\preformatted{Equations:
1 = (1-m)*(1-t)*e
2 = (1-m)*(1-t)*(1-e)
3 = m
4 = (1-m)*t*(1-e)
5 = (1-m)*t*e
}
}

\subsection{IRT}{

The \code{model} must contain a section with heading \strong{IRT}. Therein, the IRT
structure of the model is described in a way resembling the MODEL part of
an Mplus input file. It has a structure of \code{LV BY item1*, item2@1},
where \code{LV} is the name of the latent variable/parameter/process, and
\code{item} is the name of the observed variable in the data set, which
is followed by the loading. The loading may either be fixed (e.g., to 1)
using \code{@1} or it may be set free using \code{*} (which is equivalent to
omitting a loading altogether).

Each measurement model (i.e., the LV and its items) must appear on a
separate line ending with a semicolon. Items must be separated by
commas. Line breaks are allowed. For example:\preformatted{IRT:
t BY x1, x2, x3, x4, x5, x6;
e BY x1@1, x2@1, x3@1, x4@1, x5@1, x6@1;
m BY x1@1, x2@1, x3@1, x4@1, x5@1, x6@1;
}
}

\subsection{Class}{

The \code{model} must contain a section with heading \strong{Class} to specify the
type/class of IRT model to use.
Currently, may be either \code{Tree}, \code{GRM}, or \code{PCM}. For example:\preformatted{Class:
Tree
}
}

\subsection{Constraints}{

The \code{model} may contain a section with heading \strong{Constraints} to specify
equality constraints of latent variables.
Constraints may be useful for multidimensional questionnaires to link
\strong{IRT} and \strong{Equations} in a specific way.
Or, latent variables in \strong{IRT} may be constrained to equality.
\subsection{Constraints in order to link sections IRT and Equations}{

A process in the model equations (section \strong{Equations}) may correspond to
multiple latent variables (section \strong{IRT}).
For example, when analyzing a Big Five data set, one may wish to specify only
one extremity process \emph{e} for all items but multiple target traits \emph{t}, namely,
one for each of the five scales.
In such a case, the section \strong{Equations} would list only the parameter \emph{t},
while the section \strong{IRT} would list the parameters \emph{t1}, ..., \emph{t5}.

In the framework of MPT, one would think of such a situation in terms of
multiple albeit similar trees with specific parameter contraints across
trees.
For example, one would use one tree for each Big Five scale and fix the
response style parameters to equality across trees but not the target trait
parameters.

Each line in this section has a structure of \code{Param = LV1 | LV2}, where \code{Param} is the name of the process used only in section
\strong{Equations} and \code{LV1} it the name of the process used only in
section \strong{IRT}.
Use one line for each definition. For example:\preformatted{Constraints:
t = t1 | t2 | t3 | t4 | t5
}
}

\subsection{Constraints within section IRT}{

For example, in a sequential model as proposed by Tutz as well as Verhelst,
one would specify two processes for a 3-point item. The first process would
correspond to a pseudoitem of \code{0-1-1} and the second process to a
pseudoitem of \code{NA-0-1}.
However, the latent variables corresponding to these two processes would
typically be assumed to be equal and need thus be constrained accordingly.

Each line in this section has a structure of \code{LV1 = LV2}, where
\code{LV1} and \code{LV2} are the names of the latent variables used in
section \strong{IRT}.
Use one line for each definition. For example:\preformatted{Constraints:
LV1 = LV2
LV1 = LV3
}
}

}

\subsection{Addendum}{

The \code{model} may contain a section with heading \strong{Addendum} if
\code{engine = "mplus"} is used for estimation.
Any code in this section is directly pasted in the \code{MODEL} section of
the Mplus input file.
Use a semicolon at the end of each line; lines must not exceed 90 characters.
Note that the addendum is ignored in \code{\link[=irtree_gen_data]{irtree_gen_data()}}. For example:\preformatted{Addendum:
e WITH t@0;
m WITH t@0;
}
}

\subsection{Weights}{

The \code{model} may contain a section with heading \strong{Weights} if model
\strong{Class} is PCM.
This allows to specify (uni- and) multidimensional partial credit models.
They have been proposed, for example, by Wetzel and Carstensen (2017), as
an alternative to IR-tree models.
Note that fitting these models is only implemented for \code{engine = "tam"}.

Each line in this section has a structure of \code{LV = weights}, where \code{LV} is
the name of the latent variable used in section \strong{IRT}.
\code{weights} must be valid R code, namely, a vector of weights (see, e.g.,
Table 1 in Wetzel & Carstensen, 2017, or Table 2 in Falk & Cai, 2015).
Use one line for each definition. For example:\preformatted{Weights:
t = c(0, 1, 2, 3, 4)
e = c(1, 0, 0, 0, 1)
m = c(0, 0, 1, 0, 0)
}
}
}

\examples{
m1 <- "
# Random comment

Equations:
1 = (1-m)*(1-t)*e
2 = (1-m)*(1-t)*(1-e)
3 = m
4 = (1-m)*t*(1-e)
5 = (1-m)*t*e

IRT:
t1 BY x1@1, x2*, x3*;
t2 BY x4@1, x5*, x6*;
e  BY x1@1, x2@1, x3@1, x4@1, x5@1, x6@1;
m  BY x1@1, x2@1, x3@1, x4@1, x5@1, x6@1;

Constraints:
t = t1 | t2

Class:
Tree
"

model <- irtree_model(m1)
}
