#' IPIP Big Five personality test answers (data set)
#'
#' @description "This is data from an online big five personality test:
#' http://personality-testing.info/tests/BIG5.php. The following items
#' were rated on a likert scale from 1=disagree to 5=agree in relation to how
#' much they applied to the test taker, they were presented to the taker 5 per
#' page" (Jackson, 2012).
#'
#' The following items are reverse keyed and were already recoded: `A1`, `E2`,
#' `C2`, `N2`, `O2`, `A3`, `E4`, `C4`, `N4`, `O4`, `A5`, `E6`, `C6`, `O6`, `A7`,
#' `E8`, `C8`, and `E10`.
#'
#' @details The data set included here is Version 3 from 15.10.2012. It was
#'   released by Andrew Jackson under the [CC BY
#'   4.0](https://creativecommons.org/licenses/by/4.0/) license.
#'
#' @format A data frame with 9051 rows and 58 variables:
#' \describe{
#'   \item{E1}{Am the life of the party.}
#'   \item{A1}{Feel little concern for others.}
#'   \item{C1}{Am always prepared.}
#'   \item{N1}{Get stressed out easily.}
#'   \item{O1}{Have a rich vocabulary.}
#'   \item{E2}{Don't talk a lot.}
#'   \item{A2}{Am interested in people.}
#'   \item{C2}{Leave my belongings around.}
#'   \item{N2}{Am relaxed most of the time.}
#'   \item{O2}{Have difficulty understanding abstract ideas.}
#'   \item{E3}{Feel comfortable around people.}
#'   \item{A3}{Insult people.}
#'   \item{C3}{Pay attention to details.}
#'   \item{N3}{Worry about things.}
#'   \item{O3}{Have a vivid imagination.}
#'   \item{E4}{Keep in the background.}
#'   \item{A4}{Sympathize with others' feelings.}
#'   \item{C4}{Make a mess of things.}
#'   \item{N4}{Seldom feel blue.}
#'   \item{O4}{Am not interested in abstract ideas.}
#'   \item{E5}{Start conversations.}
#'   \item{A5}{Am not interested in other people's problems.}
#'   \item{C5}{Get chores done right away.}
#'   \item{N5}{Am easily disturbed.}
#'   \item{O5}{Have excellent ideas.}
#'   \item{E6}{Have little to say.}
#'   \item{A6}{Have a soft heart.}
#'   \item{C6}{Often forget to put things back in their proper place.}
#'   \item{N6}{Get upset easily.}
#'   \item{O6}{Do not have a good imagination.}
#'   \item{E7}{Talk to a lot of different people at parties.}
#'   \item{A7}{Am not really interested in others.}
#'   \item{C7}{Like order}
#'   \item{N7}{Change my mood a lot.}
#'   \item{O7}{Am quick to understand things.}
#'   \item{E8}{Don't like to draw attention to myself.}
#'   \item{A8}{Take time out for others.}
#'   \item{C8}{Shirk my duties.}
#'   \item{N8}{Have frequent mood swings.}
#'   \item{O8}{Use difficult words.}
#'   \item{E9}{Don't mind being the center of attention.}
#'   \item{A9}{Feel others' emotions.}
#'   \item{C9}{Follow a schedule.}
#'   \item{N9}{Get irritated easily.}
#'   \item{O9}{Spend time reflecting on things.}
#'   \item{E10}{Am quiet around strangers.}
#'   \item{A10}{Make people feel at ease.}
#'   \item{C10}{Am exacting in my work.}
#'   \item{N10}{Often feel blue.}
#'   \item{O10}{Am full of ideas.}
#'   \item{gender}{Gender, either female, male, or other}
#'   \item{age}{Age}
#'   \item{SecondsElapsed}{Seconds elapsed}
#'   \item{E}{Scale mean for extraversion}
#'   \item{C}{Scale mean for conscientiousness}
#'   \item{N}{Scale mean for neuroticism}
#'   \item{O}{Scale mean for openness}
#'   \item{A}{Scale mean for agreeableness}
#' }
#' @usage data("jackson")
#' @source Jackson, A. (2012). IPIP Big Five personality test answers.
#'   \url{https://doi.org/10.6084/m9.figshare.96542.v3}
"jackson"
