% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-arithmetic.R
\docType{methods}
\name{arithmetic}
\alias{arithmetic}
\alias{+,numeric,IntervalData-method}
\alias{+,IntervalData,numeric-method}
\alias{+,IntervalData,IntervalData-method}
\alias{-,numeric,IntervalData-method}
\alias{-,IntervalData,numeric-method}
\alias{-,IntervalData,IntervalData-method}
\alias{-,IntervalData,ANY-method}
\alias{*,numeric,IntervalData-method}
\alias{*,IntervalData,numeric-method}
\title{Interval arithmetic operations}
\usage{
\S4method{+}{numeric,IntervalData}(e1, e2)

\S4method{+}{IntervalData,numeric}(e1, e2)

\S4method{+}{IntervalData,IntervalData}(e1, e2)

\S4method{-}{numeric,IntervalData}(e1, e2)

\S4method{-}{IntervalData,numeric}(e1, e2)

\S4method{-}{IntervalData,IntervalData}(e1, e2)

\S4method{-}{IntervalData,ANY}(e1, e2) # -e1

\S4method{*}{numeric,IntervalData}(e1, e2)

\S4method{*}{IntervalData,numeric}(e1, e2)
}
\arguments{
\item{e1}{an interval-valued data or single numeric value.}

\item{e2}{an interval-valued data or single numeric value.}
}
\value{
Returns an interval-valued data of the class \code{\linkS4class{IntervalData}}.
}
\description{
Applies arithmetic operations using interval-based calculations.
}
\details{
Implementation of Minkowski's sum and product by a scalar operators: \code{+}, \code{-}, \code{*}.
Using mid/spr-characterisation, these operations can be settled for two interval-valued
data \eqn{A} and \eqn{B} and a real number \eqn{\gamma} as follows:
\deqn{A + B = [(\mathrm{mid}~A +\mathrm{mid}~B) \mp (\mathrm{spr}~A +\mathrm{spr}~B)]} and
\deqn{\gamma \cdot A =
\left\{ \begin{array}{ll}
\left[\gamma\cdot \mathrm{mid}~A\mp\gamma\cdot\mathrm{spr}~A\right] & \hbox{if $\gamma \geq 0$,}\\[1.5ex]
\left[\gamma\cdot \mathrm{mid}~A\pm\gamma\cdot\mathrm{spr}~A\right] & \hbox{if $\gamma < 0$.}\end{array}\right.}
}
\examples{
i1 <- IntervalData(0, 1)
i2 <- IntervalData(2, 3)
-i1
i1 + 1
1 + i1
i1 - 1
1 - i1
i1 + i2
i1 - i2
2*i1
i1*2
-2*i1
i1*(-2)

## Note that i1-i1 is not {0}
i1-i1
}
\references{
\itemize{
\item Minkowski, H. (1903). Volumen und oberflache. Mathematische Annalen, 57:447-495.
\item Moore, R.E.; Kearfott, R.B.; Cloud, M.J. (2009). Introduction to Interval Analysis. Society
for Industrial and Applied Mathematics, USA.
}
}
\seealso{
Other IntervalData-method: 
\code{\link{IntervalData-class}},
\code{\link{IntervalData}},
\code{\link{as.IntervalData}()},
\code{\link{distance}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{plot}()},
\code{\link{show}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalData-method}
