/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat;

import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.jet.math.tfloat.FloatArithmetic;
import cern.jet.stat.tdouble.Gamma;

public class FloatDescriptive {
    protected FloatDescriptive() {
    }

    public static float autoCorrelation(FloatArrayList floatArrayList, int n, float f, float f2) {
        int n2 = floatArrayList.size();
        if (n >= n2) {
            throw new IllegalArgumentException("Lag is too large");
        }
        float[] fArray = floatArrayList.elements();
        float f3 = 0.0f;
        for (int i = n; i < n2; ++i) {
            f3 += (fArray[i] - f) * (fArray[i - n] - f);
        }
        return f3 / (float)(n2 - n) / f2;
    }

    protected static void checkRangeFromTo(int n, int n2, int n3) {
        if (n2 == n - 1) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= n3) {
            throw new IndexOutOfBoundsException("from: " + n + ", to: " + n2 + ", size=" + n3);
        }
    }

    public static float correlation(FloatArrayList floatArrayList, float f, FloatArrayList floatArrayList2, float f2) {
        return FloatDescriptive.covariance(floatArrayList, floatArrayList2) / (f * f2);
    }

    public static float covariance(FloatArrayList floatArrayList, FloatArrayList floatArrayList2) {
        int n = floatArrayList.size();
        if (n != floatArrayList2.size() || n == 0) {
            throw new IllegalArgumentException();
        }
        float[] fArray = floatArrayList.elements();
        float[] fArray2 = floatArrayList2.elements();
        float f = fArray[0];
        float f2 = fArray2[0];
        float f3 = 0.0f;
        for (int i = 1; i < n; ++i) {
            float f4 = fArray[i];
            float f5 = fArray2[i];
            f3 += (f4 - (f += f4) / (float)(i + 1)) * (f5 - f2 / (float)i);
            f2 += f5;
        }
        return f3 / (float)(n - 1);
    }

    private static float covariance2(FloatArrayList floatArrayList, FloatArrayList floatArrayList2) {
        int n = floatArrayList.size();
        float f = FloatDescriptive.mean(floatArrayList);
        float f2 = FloatDescriptive.mean(floatArrayList2);
        float f3 = 0.0f;
        for (int i = 0; i < n; ++i) {
            float f4 = floatArrayList.get(i);
            float f5 = floatArrayList2.get(i);
            f3 += (f4 - f) * (f5 - f2);
        }
        return f3 / (float)(n - 1);
    }

    public static float durbinWatson(FloatArrayList floatArrayList) {
        int n = floatArrayList.size();
        if (n < 2) {
            throw new IllegalArgumentException("data sequence must contain at least two values.");
        }
        float[] fArray = floatArrayList.elements();
        float f = 0.0f;
        float f2 = 0.0f;
        f2 = fArray[0] * fArray[0];
        for (int i = 1; i < n; ++i) {
            float f3 = fArray[i] - fArray[i - 1];
            f += f3 * f3;
            f2 += fArray[i] * fArray[i];
        }
        return f / f2;
    }

    public static void frequencies(FloatArrayList floatArrayList, FloatArrayList floatArrayList2, IntArrayList intArrayList) {
        floatArrayList2.clear();
        if (intArrayList != null) {
            intArrayList.clear();
        }
        float[] fArray = floatArrayList.elements();
        int n = floatArrayList.size();
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            int n3 = n2;
            while (++n2 < n && fArray[n2] == f) {
            }
            int n4 = n2 - n3;
            floatArrayList2.add(f);
            if (intArrayList == null) continue;
            intArrayList.add(n4);
        }
    }

    public static float geometricMean(int n, float f) {
        return (float)Math.exp(f / (float)n);
    }

    public static float geometricMean(FloatArrayList floatArrayList) {
        return FloatDescriptive.geometricMean(floatArrayList.size(), FloatDescriptive.sumOfLogarithms(floatArrayList, 0, floatArrayList.size() - 1));
    }

    public static float harmonicMean(int n, float f) {
        return (float)n / f;
    }

    public static void incrementalUpdate(FloatArrayList floatArrayList, int n, int n2, float[] fArray) {
        FloatDescriptive.checkRangeFromTo(n, n2, floatArrayList.size());
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        float[] fArray2 = floatArrayList.elements();
        while (n <= n2) {
            float f5 = fArray2[n];
            f3 += f5;
            f4 += f5 * f5;
            if (f5 < f) {
                f = f5;
            }
            if (f5 > f2) {
                f2 = f5;
            }
            ++n;
        }
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = f4;
    }

    public static void incrementalUpdateSumsOfPowers(FloatArrayList floatArrayList, int n, int n2, int n3, int n4, float[] fArray) {
        int n5 = floatArrayList.size();
        int n6 = n4 - n3;
        if (n > n5 || n6 + 1 > fArray.length) {
            throw new IllegalArgumentException();
        }
        if (n3 == 1) {
            if (n4 == 2) {
                float[] fArray2 = floatArrayList.elements();
                float f = fArray[0];
                float f2 = fArray[1];
                int n7 = n - 1;
                while (++n7 <= n2) {
                    float f3 = fArray2[n7];
                    f += f3;
                    f2 += f3 * f3;
                }
                fArray[0] = fArray[0] + f;
                fArray[1] = fArray[1] + f2;
                return;
            }
            if (n4 == 3) {
                float[] fArray3 = floatArrayList.elements();
                float f = fArray[0];
                float f4 = fArray[1];
                float f5 = fArray[2];
                int n8 = n - 1;
                while (++n8 <= n2) {
                    float f6 = fArray3[n8];
                    f += f6;
                    f4 += f6 * f6;
                    f5 += f6 * f6 * f6;
                }
                fArray[0] = fArray[0] + f;
                fArray[1] = fArray[1] + f4;
                fArray[2] = fArray[2] + f5;
                return;
            }
            if (n4 == 4) {
                float[] fArray4 = floatArrayList.elements();
                float f = fArray[0];
                float f7 = fArray[1];
                float f8 = fArray[2];
                float f9 = fArray[3];
                int n9 = n - 1;
                while (++n9 <= n2) {
                    float f10 = fArray4[n9];
                    f += f10;
                    f7 += f10 * f10;
                    f8 += f10 * f10 * f10;
                    f9 += f10 * f10 * f10 * f10;
                }
                fArray[0] = fArray[0] + f;
                fArray[1] = fArray[1] + f7;
                fArray[2] = fArray[2] + f8;
                fArray[3] = fArray[3] + f9;
                return;
            }
        }
        if (n3 == n4 || n3 >= -1 && n4 <= 5) {
            for (int i = n3; i <= n4; ++i) {
                int n10 = i - n3;
                fArray[n10] = fArray[n10] + FloatDescriptive.sumOfPowerDeviations(floatArrayList, i, 0.0f, n, n2);
            }
            return;
        }
        float[] fArray5 = floatArrayList.elements();
        int n11 = n - 1;
        while (++n11 <= n2) {
            float f = fArray5[n11];
            float f11 = (float)Math.pow(f, n3);
            int n12 = 0;
            int n13 = n6;
            while (--n13 >= 0) {
                int n14 = n12++;
                fArray[n14] = fArray[n14] + f11;
                f11 *= f;
            }
            int n15 = n12;
            fArray[n15] = fArray[n15] + f11;
        }
    }

    public static void incrementalWeightedUpdate(FloatArrayList floatArrayList, FloatArrayList floatArrayList2, int n, int n2, float[] fArray) {
        int n3 = floatArrayList.size();
        FloatDescriptive.checkRangeFromTo(n, n2, n3);
        if (n3 != floatArrayList2.size()) {
            throw new IllegalArgumentException("from=" + n + ", to=" + n2 + ", data.size()=" + n3 + ", weights.size()=" + floatArrayList2.size());
        }
        float f = fArray[0];
        float f2 = fArray[1];
        float[] fArray2 = floatArrayList.elements();
        float[] fArray3 = floatArrayList2.elements();
        int n4 = n - 1;
        while (++n4 <= n2) {
            float f3 = fArray2[n4];
            float f4 = fArray3[n4];
            float f5 = f3 * f4;
            f += f5;
            f2 += f3 * f5;
        }
        fArray[0] = f;
        fArray[1] = f2;
    }

    public static float kurtosis(float f, float f2) {
        return -3.0f + f / (f2 * f2 * f2 * f2);
    }

    public static float kurtosis(FloatArrayList floatArrayList, float f, float f2) {
        return FloatDescriptive.kurtosis(FloatDescriptive.moment(floatArrayList, 4, f), f2);
    }

    public static float lag1(FloatArrayList floatArrayList, float f) {
        int n = floatArrayList.size();
        float[] fArray = floatArrayList.elements();
        float f2 = 0.0f;
        float f3 = (fArray[0] - f) * (fArray[0] - f);
        for (int i = 1; i < n; ++i) {
            float f4 = fArray[i - 1] - f;
            float f5 = fArray[i] - f;
            f2 += (f4 * f5 - f2) / (float)(i + 1);
            f3 += (f5 * f5 - f3) / (float)(i + 1);
        }
        float f6 = f2 / f3;
        return f6;
    }

    public static float max(FloatArrayList floatArrayList) {
        int n = floatArrayList.size();
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        float[] fArray = floatArrayList.elements();
        float f = fArray[n - 1];
        int n2 = n - 1;
        while (--n2 >= 0) {
            if (!(fArray[n2] > f)) continue;
            f = fArray[n2];
        }
        return f;
    }

    public static float mean(FloatArrayList floatArrayList) {
        return FloatDescriptive.sum(floatArrayList) / (float)floatArrayList.size();
    }

    public static float meanDeviation(FloatArrayList floatArrayList, float f) {
        float[] fArray = floatArrayList.elements();
        int n = floatArrayList.size();
        float f2 = 0.0f;
        int n2 = n;
        while (--n2 >= 0) {
            f2 += Math.abs(fArray[n2] - f);
        }
        return f2 / (float)n;
    }

    public static float median(FloatArrayList floatArrayList) {
        return FloatDescriptive.quantile(floatArrayList, 0.5f);
    }

    public static float min(FloatArrayList floatArrayList) {
        int n = floatArrayList.size();
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        float[] fArray = floatArrayList.elements();
        float f = fArray[n - 1];
        int n2 = n - 1;
        while (--n2 >= 0) {
            if (!(fArray[n2] < f)) continue;
            f = fArray[n2];
        }
        return f;
    }

    public static float moment(int n, float f, int n2, float[] fArray) {
        float f2 = 0.0f;
        int n3 = 1;
        for (int i = 0; i <= n; ++i) {
            float f3 = i == 0 ? 1.0f : (i == 1 ? f : (i == 2 ? f * f : (i == 3 ? f * f * f : (float)Math.pow(f, i))));
            f2 += (float)n3 * FloatArithmetic.binomial(n, (long)i) * f3 * fArray[n - i];
            n3 = -n3;
        }
        return f2 / (float)n2;
    }

    public static float moment(FloatArrayList floatArrayList, int n, float f) {
        return FloatDescriptive.sumOfPowerDeviations(floatArrayList, n, f) / (float)floatArrayList.size();
    }

    public static float pooledMean(int n, float f, int n2, float f2) {
        return ((float)n * f + (float)n2 * f2) / (float)(n + n2);
    }

    public static float pooledVariance(int n, float f, int n2, float f2) {
        return ((float)n * f + (float)n2 * f2) / (float)(n + n2);
    }

    public static float product(int n, float f) {
        return (float)Math.pow(Math.exp(f / (float)n), n);
    }

    public static float product(FloatArrayList floatArrayList) {
        int n = floatArrayList.size();
        float[] fArray = floatArrayList.elements();
        float f = 1.0f;
        int n2 = n;
        while (--n2 >= 0) {
            f *= fArray[n2];
        }
        return f;
    }

    public static float quantile(FloatArrayList floatArrayList, float f) {
        float[] fArray = floatArrayList.elements();
        int n = floatArrayList.size();
        float f2 = f * (float)(n - 1);
        int n2 = (int)f2;
        float f3 = f2 - (float)n2;
        if (n == 0) {
            return 0.0f;
        }
        float f4 = n2 == n - 1 ? fArray[n2] : (1.0f - f3) * fArray[n2] + f3 * fArray[n2 + 1];
        return f4;
    }

    public static float quantileInverse(FloatArrayList floatArrayList, float f) {
        return FloatDescriptive.rankInterpolated(floatArrayList, f) / (float)floatArrayList.size();
    }

    public static FloatArrayList quantiles(FloatArrayList floatArrayList, FloatArrayList floatArrayList2) {
        int n = floatArrayList2.size();
        FloatArrayList floatArrayList3 = new FloatArrayList(n);
        for (int i = 0; i < n; ++i) {
            floatArrayList3.add(FloatDescriptive.quantile(floatArrayList, floatArrayList2.get(i)));
        }
        return floatArrayList3;
    }

    public static float rankInterpolated(FloatArrayList floatArrayList, float f) {
        int n = floatArrayList.binarySearch(f);
        if (n >= 0) {
            int n2;
            int n3 = floatArrayList.size();
            for (n2 = n + 1; n2 < n3 && floatArrayList.get(n2) == f; ++n2) {
            }
            return n2;
        }
        int n4 = -n - 1;
        if (n4 == 0 || n4 == floatArrayList.size()) {
            return n4;
        }
        float f2 = floatArrayList.get(n4 - 1);
        float f3 = floatArrayList.get(n4);
        float f4 = (f - f2) / (f3 - f2);
        return (float)n4 + f4;
    }

    public static float rms(int n, float f) {
        return (float)Math.sqrt(f / (float)n);
    }

    public static float sampleKurtosis(int n, float f, float f2) {
        int n2 = n;
        float f3 = f2;
        float f4 = f * (float)n2;
        return (float)((double)(f4 * (float)n2 * (float)(n2 + 1) / ((float)((n2 - 1) * (n2 - 2) * (n2 - 3)) * f3 * f3)) - 3.0 * (double)(n2 - 1) * (double)(n2 - 1) / (double)((n2 - 2) * (n2 - 3)));
    }

    public static float sampleKurtosis(FloatArrayList floatArrayList, float f, float f2) {
        return FloatDescriptive.sampleKurtosis(floatArrayList.size(), FloatDescriptive.moment(floatArrayList, 4, f), f2);
    }

    public static float sampleKurtosisStandardError(int n) {
        int n2 = n;
        return (float)Math.sqrt(24.0 * (double)n2 * (double)(n2 - 1) * (double)(n2 - 1) / (double)((n2 - 3) * (n2 - 2) * (n2 + 3) * (n2 + 5)));
    }

    public static float sampleSkew(int n, float f, float f2) {
        int n2 = n;
        float f3 = (float)Math.sqrt(f2);
        float f4 = f * (float)n2;
        return (float)n2 * f4 / ((float)((n2 - 1) * (n2 - 2)) * f3 * f3 * f3);
    }

    public static float sampleSkew(FloatArrayList floatArrayList, float f, float f2) {
        return FloatDescriptive.sampleSkew(floatArrayList.size(), FloatDescriptive.moment(floatArrayList, 3, f), f2);
    }

    public static float sampleSkewStandardError(int n) {
        int n2 = n;
        return (float)Math.sqrt(6.0 * (double)n2 * (double)(n2 - 1) / (double)((n2 - 2) * (n2 + 1) * (n2 + 3)));
    }

    public static float sampleStandardDeviation(int n, float f) {
        int n2 = n;
        float f2 = (float)Math.sqrt(f);
        float f3 = n2 > 30 ? (float)(1.0 + 1.0 / (double)(4 * (n2 - 1))) : (float)(Math.sqrt((double)(n2 - 1) * 0.5) * Gamma.gamma((double)(n2 - 1) * 0.5) / Gamma.gamma((double)n2 * 0.5));
        return f3 * f2;
    }

    public static float sampleVariance(int n, float f, float f2) {
        float f3 = f / (float)n;
        return (f2 - f3 * f) / (float)(n - 1);
    }

    public static float sampleVariance(FloatArrayList floatArrayList, float f) {
        float[] fArray = floatArrayList.elements();
        int n = floatArrayList.size();
        float f2 = 0.0f;
        int n2 = n;
        while (--n2 >= 0) {
            float f3 = fArray[n2] - f;
            f2 += f3 * f3;
        }
        return f2 / (float)(n - 1);
    }

    public static float sampleWeightedVariance(float f, float f2, float f3) {
        return (f3 - f2 * f2 / f) / (f - 1.0f);
    }

    public static float skew(float f, float f2) {
        return f / (f2 * f2 * f2);
    }

    public static float skew(FloatArrayList floatArrayList, float f, float f2) {
        return FloatDescriptive.skew(FloatDescriptive.moment(floatArrayList, 3, f), f2);
    }

    public static FloatArrayList[] split(FloatArrayList floatArrayList, FloatArrayList floatArrayList2) {
        int n = floatArrayList2.size() + 1;
        FloatArrayList[] floatArrayListArray = new FloatArrayList[n];
        int n2 = n;
        while (--n2 >= 0) {
            floatArrayListArray[n2] = new FloatArrayList();
        }
        n2 = floatArrayList.size();
        int n3 = 0;
        for (int i = 0; n3 < n2 && i < n - 1; ++i) {
            float f = floatArrayList2.get(i);
            int n4 = floatArrayList.binarySearch(f);
            if (n4 < 0) {
                int n5 = -n4 - 1;
                floatArrayListArray[i].addAllOfFromTo(floatArrayList, n3, n5 - 1);
                n3 = n5;
                continue;
            }
            while (--n4 >= 0 && floatArrayList.get(n4) == f) {
            }
            floatArrayListArray[i].addAllOfFromTo(floatArrayList, n3, n4);
            n3 = n4 + 1;
        }
        floatArrayListArray[n - 1].addAllOfFromTo(floatArrayList, n3, floatArrayList.size() - 1);
        return floatArrayListArray;
    }

    public static float standardDeviation(float f) {
        return (float)Math.sqrt(f);
    }

    public static float standardError(int n, float f) {
        return (float)Math.sqrt(f / (float)n);
    }

    public static void standardize(FloatArrayList floatArrayList, float f, float f2) {
        float[] fArray = floatArrayList.elements();
        int n = floatArrayList.size();
        while (--n >= 0) {
            fArray[n] = (fArray[n] - f) / f2;
        }
    }

    public static float sum(FloatArrayList floatArrayList) {
        return FloatDescriptive.sumOfPowerDeviations(floatArrayList, 1, 0.0f);
    }

    public static float sumOfInversions(FloatArrayList floatArrayList, int n, int n2) {
        return FloatDescriptive.sumOfPowerDeviations(floatArrayList, -1, 0.0f, n, n2);
    }

    public static float sumOfLogarithms(FloatArrayList floatArrayList, int n, int n2) {
        float[] fArray = floatArrayList.elements();
        float f = 0.0f;
        int n3 = n - 1;
        while (++n3 <= n2) {
            f = (float)((double)f + Math.log(fArray[n3]));
        }
        return f;
    }

    public static float sumOfPowerDeviations(FloatArrayList floatArrayList, int n, float f) {
        return FloatDescriptive.sumOfPowerDeviations(floatArrayList, n, f, 0, floatArrayList.size() - 1);
    }

    public static float sumOfPowerDeviations(FloatArrayList floatArrayList, int n, float f, int n2, int n3) {
        float[] fArray = floatArrayList.elements();
        float f2 = 0.0f;
        switch (n) {
            case -2: {
                if ((double)f == 0.0) {
                    int n4 = n2 - 1;
                    while (++n4 <= n3) {
                        float f3 = fArray[n4];
                        f2 += 1.0f / (f3 * f3);
                    }
                } else {
                    int n5 = n2 - 1;
                    while (++n5 <= n3) {
                        float f4 = fArray[n5] - f;
                        f2 += 1.0f / (f4 * f4);
                    }
                }
                break;
            }
            case -1: {
                if ((double)f == 0.0) {
                    int n6 = n2 - 1;
                    while (++n6 <= n3) {
                        f2 += 1.0f / fArray[n6];
                    }
                } else {
                    int n7 = n2 - 1;
                    while (++n7 <= n3) {
                        f2 += 1.0f / (fArray[n7] - f);
                    }
                }
                break;
            }
            case 0: {
                f2 += (float)(n3 - n2 + 1);
                break;
            }
            case 1: {
                if ((double)f == 0.0) {
                    int n8 = n2 - 1;
                    while (++n8 <= n3) {
                        f2 += fArray[n8];
                    }
                } else {
                    int n9 = n2 - 1;
                    while (++n9 <= n3) {
                        f2 += fArray[n9] - f;
                    }
                }
                break;
            }
            case 2: {
                if ((double)f == 0.0) {
                    int n10 = n2 - 1;
                    while (++n10 <= n3) {
                        float f5 = fArray[n10];
                        f2 += f5 * f5;
                    }
                } else {
                    int n11 = n2 - 1;
                    while (++n11 <= n3) {
                        float f6 = fArray[n11] - f;
                        f2 += f6 * f6;
                    }
                }
                break;
            }
            case 3: {
                if ((double)f == 0.0) {
                    int n12 = n2 - 1;
                    while (++n12 <= n3) {
                        float f7 = fArray[n12];
                        f2 += f7 * f7 * f7;
                    }
                } else {
                    int n13 = n2 - 1;
                    while (++n13 <= n3) {
                        float f8 = fArray[n13] - f;
                        f2 += f8 * f8 * f8;
                    }
                }
                break;
            }
            case 4: {
                if ((double)f == 0.0) {
                    int n14 = n2 - 1;
                    while (++n14 <= n3) {
                        float f9 = fArray[n14];
                        f2 += f9 * f9 * f9 * f9;
                    }
                } else {
                    int n15 = n2 - 1;
                    while (++n15 <= n3) {
                        float f10 = fArray[n15] - f;
                        f2 += f10 * f10 * f10 * f10;
                    }
                }
                break;
            }
            case 5: {
                if ((double)f == 0.0) {
                    int n16 = n2 - 1;
                    while (++n16 <= n3) {
                        float f11 = fArray[n16];
                        f2 += f11 * f11 * f11 * f11 * f11;
                    }
                } else {
                    int n17 = n2 - 1;
                    while (++n17 <= n3) {
                        float f12 = fArray[n17] - f;
                        f2 += f12 * f12 * f12 * f12 * f12;
                    }
                }
                break;
            }
            default: {
                int n18 = n2 - 1;
                while (++n18 <= n3) {
                    f2 = (float)((double)f2 + Math.pow(fArray[n18] - f, n));
                }
                break block0;
            }
        }
        return f2;
    }

    public static float sumOfPowers(FloatArrayList floatArrayList, int n) {
        return FloatDescriptive.sumOfPowerDeviations(floatArrayList, n, 0.0f);
    }

    public static float sumOfSquaredDeviations(int n, float f) {
        return f * (float)(n - 1);
    }

    public static float sumOfSquares(FloatArrayList floatArrayList) {
        return FloatDescriptive.sumOfPowerDeviations(floatArrayList, 2, 0.0f);
    }

    public static float trimmedMean(FloatArrayList floatArrayList, float f, int n, int n2) {
        int n3;
        int n4 = floatArrayList.size();
        if (n4 == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (n + n2 >= n4) {
            throw new IllegalArgumentException("Not enough data.");
        }
        float[] fArray = floatArrayList.elements();
        int n5 = n4;
        for (n3 = 0; n3 < n; ++n3) {
            f += (f - fArray[n3]) / (float)(--n4);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            f += (f - fArray[n5 - 1 - n3]) / (float)(--n4);
        }
        return f;
    }

    public static float variance(float f) {
        return f * f;
    }

    public static float variance(int n, float f, float f2) {
        float f3 = f / (float)n;
        return (f2 - f3 * f) / (float)n;
    }

    public static float weightedMean(FloatArrayList floatArrayList, FloatArrayList floatArrayList2) {
        int n = floatArrayList.size();
        if (n != floatArrayList2.size() || n == 0) {
            throw new IllegalArgumentException();
        }
        float[] fArray = floatArrayList.elements();
        float[] fArray2 = floatArrayList2.elements();
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = n;
        while (--n2 >= 0) {
            float f3 = fArray2[n2];
            f += fArray[n2] * f3;
            f2 += f3;
        }
        return f / f2;
    }

    public static float weightedRMS(float f, float f2) {
        return f / f2;
    }

    public static float winsorizedMean(FloatArrayList floatArrayList, float f, int n, int n2) {
        int n3 = floatArrayList.size();
        if (n3 == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (n + n2 >= n3) {
            throw new IllegalArgumentException("Not enough data.");
        }
        float[] fArray = floatArrayList.elements();
        float f2 = fArray[n];
        for (int i = 0; i < n; ++i) {
            f += (f2 - fArray[i]) / (float)n3;
        }
        float f3 = fArray[n3 - 1 - n2];
        for (int i = 0; i < n2; ++i) {
            f += (f3 - fArray[n3 - 1 - i]) / (float)n3;
        }
        return f;
    }
}

