/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class Distributions {
    protected Distributions() {
        throw new RuntimeException("Non instantiable");
    }

    public static double geometricPdf(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return d * Math.pow(1.0 - d, n);
    }

    public static double nextBurr1(double d, int n, DoubleRandomEngine doubleRandomEngine) {
        double d2 = Math.exp(Math.log(doubleRandomEngine.raw()) / d);
        switch (n) {
            case 2: {
                return -Math.log(1.0 / d2 - 1.0);
            }
            case 7: {
                return Math.log(2.0 * d2 / (2.0 - 2.0 * d2)) / 2.0;
            }
            case 8: {
                return Math.log(Math.tan(d2 * Math.PI / 2.0));
            }
            case 10: {
                return Math.sqrt(-Math.log(1.0 - d2));
            }
        }
        return 0.0;
    }

    public static double nextBurr2(double d, double d2, int n, DoubleRandomEngine doubleRandomEngine) {
        double d3 = doubleRandomEngine.raw();
        double d4 = Math.exp(-Math.log(d3) / d) - 1.0;
        switch (n) {
            case 3: {
                return Math.exp(-Math.log(d4) / d2);
            }
            case 4: {
                d4 = Math.exp(d2 * Math.log(d4)) + 1.0;
                d4 = d2 / d4;
                return d4;
            }
            case 5: {
                d4 = Math.atan(-Math.log(d4 / d2));
                return d4;
            }
            case 6: {
                d4 = -Math.log(d4 / d2) / d;
                d4 = Math.log(d4 + Math.sqrt(d4 * d4 + 1.0));
                return d4;
            }
            case 9: {
                d4 = 1.0 + 2.0 * d3 / (d2 * (1.0 - d3));
                d4 = Math.exp(Math.log(d4) / d) - 1.0;
                return Math.log(d4);
            }
            case 12: {
                return Math.exp(Math.log(d4) / d2);
            }
        }
        return 0.0;
    }

    public static double nextCauchy(DoubleRandomEngine doubleRandomEngine) {
        return Math.tan(Math.PI * doubleRandomEngine.raw());
    }

    public static double nextErlang(double d, double d2, DoubleRandomEngine doubleRandomEngine) {
        int n = (int)(d2 * d2 / d + 0.5);
        n = n > 0 ? n : 1;
        double d3 = (double)n / d2;
        double d4 = 1.0;
        for (int i = 0; i < n; ++i) {
            d4 *= doubleRandomEngine.raw();
        }
        return -Math.log(d4) / d3;
    }

    public static int nextGeometric(double d, DoubleRandomEngine doubleRandomEngine) {
        double d2 = doubleRandomEngine.raw();
        return (int)(Math.log(d2) / Math.log(1.0 - d));
    }

    public static double nextLambda(double d, double d2, DoubleRandomEngine doubleRandomEngine) {
        double d3 = d < 0.0 || d2 < 0.0 ? -1.0 : 1.0;
        double d4 = doubleRandomEngine.raw();
        double d5 = d3 * (Math.exp(Math.log(d4) * d) - Math.exp(Math.log(1.0 - d4) * d2));
        return d5;
    }

    public static double nextLaplace(DoubleRandomEngine doubleRandomEngine) {
        double d = doubleRandomEngine.raw();
        if ((d = d + d - 1.0) > 0.0) {
            return -Math.log(1.0 - d);
        }
        return Math.log(1.0 + d);
    }

    public static double nextLogistic(DoubleRandomEngine doubleRandomEngine) {
        double d = doubleRandomEngine.raw();
        return -Math.log(1.0 / d - 1.0);
    }

    public static double nextPowLaw(double d, double d2, DoubleRandomEngine doubleRandomEngine) {
        return d2 * Math.pow(doubleRandomEngine.raw(), 1.0 / (d + 1.0));
    }

    public static double nextTriangular(DoubleRandomEngine doubleRandomEngine) {
        double d = doubleRandomEngine.raw();
        if (d <= 0.5) {
            return Math.sqrt(2.0 * d) - 1.0;
        }
        return 1.0 - Math.sqrt(2.0 * (1.0 - d));
    }

    public static double nextWeibull(double d, double d2, DoubleRandomEngine doubleRandomEngine) {
        return Math.pow(d2 * -Math.log(1.0 - doubleRandomEngine.raw()), 1.0 / d);
    }

    public static int nextZipfInt(double d, DoubleRandomEngine doubleRandomEngine) {
        double d2;
        double d3;
        double d4;
        double d5 = Math.pow(2.0, d - 1.0);
        double d6 = -1.0 / (d - 1.0);
        int n = 0;
        do {
            d3 = doubleRandomEngine.raw();
        } while (!((d4 = doubleRandomEngine.raw()) * (double)(n = (int)Math.floor(Math.pow(d3, d6))) * ((d2 = Math.pow(1.0 + 1.0 / (double)n, d - 1.0)) - 1.0) / (d5 - 1.0) <= d2 / d5));
        return n;
    }
}

