/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.algo;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.jet.math.tfcomplex.FComplex;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FComplexProperty {
    public static final FComplexProperty DEFAULT = new FComplexProperty(1.0E-5f);
    public static final FComplexProperty ZERO = new FComplexProperty(0.0f);
    public static final FComplexProperty SEVEN = new FComplexProperty(1.0E-7f);
    protected float tolerance;

    private FComplexProperty() {
        this(1.0E-5f);
    }

    public FComplexProperty(float f) {
        this.tolerance = Math.abs(f);
    }

    public void setTolerance(float f) {
        if (this == DEFAULT || this == ZERO || this == SEVEN) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.tolerance = Math.abs(f);
    }

    public float tolerance() {
        return this.tolerance;
    }

    public boolean equals(final FComplexMatrix1D fComplexMatrix1D, final float[] fArray) {
        if (fComplexMatrix1D == null) {
            return false;
        }
        final float f = this.tolerance();
        boolean bl = false;
        int n = ConcurrencyUtils.getNumberOfThreads();
        int n2 = (int)fComplexMatrix1D.size();
        if (n > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n = Math.min(n, n2);
            Future[] futureArray = new Future[n];
            Boolean[] booleanArray = new Boolean[n];
            int n4 = n2 / n;
            for (n3 = 0; n3 < n; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n - 1 ? n2 : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] fArray3 = new float[2];
                        for (int i = n5; i < n6; ++i) {
                            float[] fArray2 = fComplexMatrix1D.getQuick(i);
                            fArray3[0] = Math.abs(fArray[0] - fArray2[0]);
                            fArray3[1] = Math.abs(fArray[1] - fArray2[1]);
                            if (!((fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1] || fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1]) && !FComplex.isEqual(fArray, fArray2, f))) {
                                fArray3[0] = 0.0f;
                                fArray3[1] = 0.0f;
                            }
                            if (!(fArray3[0] > f) && !(fArray3[1] > f)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n; ++n3) {
                    booleanArray[n3] = (Boolean)futureArray[n3].get();
                }
                bl = booleanArray[0];
                for (n3 = 1; n3 < n; ++n3) {
                    bl = bl && booleanArray[n3] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        float[] fArray2 = new float[2];
        int n7 = 0;
        while ((long)n7 < fComplexMatrix1D.size()) {
            float[] fArray3 = fComplexMatrix1D.getQuick(n7);
            fArray2[0] = Math.abs(fArray[0] - fArray3[0]);
            fArray2[1] = Math.abs(fArray[1] - fArray3[1]);
            if (!((fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1] || fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1]) && !FComplex.isEqual(fArray, fArray3, f))) {
                fArray2[0] = 0.0f;
                fArray2[1] = 0.0f;
            }
            if (fArray2[0] > f || fArray2[1] > f) {
                return false;
            }
            ++n7;
        }
        return true;
    }

    public boolean equals(final FComplexMatrix1D fComplexMatrix1D, final FComplexMatrix1D fComplexMatrix1D2) {
        if (fComplexMatrix1D == fComplexMatrix1D2) {
            return true;
        }
        if (fComplexMatrix1D == null || fComplexMatrix1D2 == null) {
            return false;
        }
        int n = (int)fComplexMatrix1D.size();
        if ((long)n != fComplexMatrix1D2.size()) {
            return false;
        }
        final float f = this.tolerance();
        boolean bl = false;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            Boolean[] booleanArray = new Boolean[n2];
            int n4 = n / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? n : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] fArray = new float[2];
                        for (int i = n5; i < n6; ++i) {
                            float[] fArray2 = fComplexMatrix1D.getQuick(i);
                            float[] fArray3 = fComplexMatrix1D2.getQuick(i);
                            fArray[0] = Math.abs(fArray3[0] - fArray2[0]);
                            fArray[1] = Math.abs(fArray3[1] - fArray2[1]);
                            if (!((fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1] || fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1]) && !FComplex.isEqual(fArray3, fArray2, f))) {
                                fArray[0] = 0.0f;
                                fArray[1] = 0.0f;
                            }
                            if (!(fArray[0] > f) && !(fArray[1] > f)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    booleanArray[n3] = (Boolean)futureArray[n3].get();
                }
                bl = booleanArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    bl = bl && booleanArray[n3] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        float[] fArray = new float[2];
        for (int i = 0; i < n; ++i) {
            float[] fArray2 = fComplexMatrix1D.getQuick(i);
            float[] fArray3 = fComplexMatrix1D2.getQuick(i);
            fArray[0] = Math.abs(fArray3[0] - fArray2[0]);
            fArray[1] = Math.abs(fArray3[1] - fArray2[1]);
            if (!((fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1] || fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1]) && !FComplex.isEqual(fArray3, fArray2, f))) {
                fArray[0] = 0.0f;
                fArray[1] = 0.0f;
            }
            if (!(fArray[0] > f) && !(fArray[1] > f)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final FComplexMatrix2D fComplexMatrix2D, final float[] fArray) {
        if (fComplexMatrix2D == null) {
            return false;
        }
        int n = fComplexMatrix2D.rows();
        int n2 = fComplexMatrix2D.columns();
        boolean bl = false;
        final float f = this.tolerance();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && fComplexMatrix2D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, fComplexMatrix2D.rows());
            Future[] futureArray = new Future[n3];
            Boolean[] booleanArray = new Boolean[n3];
            int n5 = fComplexMatrix2D.rows() / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? fComplexMatrix2D.rows() : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] fArray3 = new float[2];
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < fComplexMatrix2D.columns(); ++j) {
                                float[] fArray2 = fComplexMatrix2D.getQuick(i, j);
                                fArray3[0] = Math.abs(fArray[0] - fArray2[0]);
                                fArray3[1] = Math.abs(fArray[1] - fArray2[1]);
                                if (!((fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1] || fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1]) && !FComplex.isEqual(fArray, fArray2, f))) {
                                    fArray3[0] = 0.0f;
                                    fArray3[1] = 0.0f;
                                }
                                if (!(fArray3[0] > f) && !(fArray3[1] > f)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    booleanArray[n4] = (Boolean)futureArray[n4].get();
                }
                bl = booleanArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    bl = bl && booleanArray[n4] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        float[] fArray2 = new float[2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float[] fArray3 = fComplexMatrix2D.getQuick(i, j);
                fArray2[0] = Math.abs(fArray[0] - fArray3[0]);
                fArray2[1] = Math.abs(fArray[1] - fArray3[1]);
                if (!((fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1] || fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1]) && !FComplex.isEqual(fArray, fArray3, f))) {
                    fArray2[0] = 0.0f;
                    fArray2[1] = 0.0f;
                }
                if (!(fArray2[0] > f) && !(fArray2[1] > f)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final FComplexMatrix2D fComplexMatrix2D, final FComplexMatrix2D fComplexMatrix2D2) {
        if (fComplexMatrix2D == fComplexMatrix2D2) {
            return true;
        }
        if (fComplexMatrix2D == null || fComplexMatrix2D2 == null) {
            return false;
        }
        int n = fComplexMatrix2D.rows();
        int n2 = fComplexMatrix2D.columns();
        if (n2 != fComplexMatrix2D2.columns() || n != fComplexMatrix2D2.rows()) {
            return false;
        }
        boolean bl = false;
        final float f = this.tolerance();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && fComplexMatrix2D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, fComplexMatrix2D.rows());
            Future[] futureArray = new Future[n3];
            Boolean[] booleanArray = new Boolean[n3];
            int n5 = fComplexMatrix2D.rows() / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? fComplexMatrix2D.rows() : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] fArray = new float[2];
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < fComplexMatrix2D.columns(); ++j) {
                                float[] fArray2 = fComplexMatrix2D.getQuick(i, j);
                                float[] fArray3 = fComplexMatrix2D2.getQuick(i, j);
                                fArray[0] = Math.abs(fArray3[0] - fArray2[0]);
                                fArray[1] = Math.abs(fArray3[1] - fArray2[1]);
                                if (!((fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1] || fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1]) && !FComplex.isEqual(fArray3, fArray2, f))) {
                                    fArray[0] = 0.0f;
                                    fArray[1] = 0.0f;
                                }
                                if (!(fArray[0] > f) && !(fArray[1] > f)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    booleanArray[n4] = (Boolean)futureArray[n4].get();
                }
                bl = booleanArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    bl = bl && booleanArray[n4] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        float[] fArray = new float[2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float[] fArray2 = fComplexMatrix2D.getQuick(i, j);
                float[] fArray3 = fComplexMatrix2D2.getQuick(i, j);
                fArray[0] = Math.abs(fArray3[0] - fArray2[0]);
                fArray[1] = Math.abs(fArray3[1] - fArray2[1]);
                if (!((fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1] || fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1]) && !FComplex.isEqual(fArray3, fArray2, f))) {
                    fArray[0] = 0.0f;
                    fArray[1] = 0.0f;
                }
                if (!(fArray[0] > f) && !(fArray[1] > f)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final FComplexMatrix3D fComplexMatrix3D, final float[] fArray) {
        if (fComplexMatrix3D == null) {
            return false;
        }
        int n = fComplexMatrix3D.slices();
        final int n2 = fComplexMatrix3D.rows();
        final int n3 = fComplexMatrix3D.columns();
        boolean bl = false;
        final float f = this.tolerance();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && fComplexMatrix3D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, n);
            Future[] futureArray = new Future[n4];
            Boolean[] booleanArray = new Boolean[n4];
            int n6 = n / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] fArray3 = new float[2];
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    float[] fArray2 = fComplexMatrix3D.getQuick(i, j, k);
                                    fArray3[0] = Math.abs(fArray[0] - fArray2[0]);
                                    fArray3[1] = Math.abs(fArray[1] - fArray2[1]);
                                    if (!((fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1] || fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1]) && !FComplex.isEqual(fArray, fArray2, f))) {
                                        fArray3[0] = 0.0f;
                                        fArray3[1] = 0.0f;
                                    }
                                    if (!(fArray3[0] > f) && !(fArray3[1] > f)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    booleanArray[n5] = (Boolean)futureArray[n5].get();
                }
                bl = booleanArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    bl = bl && booleanArray[n5] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        float[] fArray2 = new float[2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    float[] fArray3 = fComplexMatrix3D.getQuick(i, j, k);
                    fArray2[0] = Math.abs(fArray[0] - fArray3[0]);
                    fArray2[1] = Math.abs(fArray[1] - fArray3[1]);
                    if (!((fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1] || fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1]) && !FComplex.isEqual(fArray, fArray3, f))) {
                        fArray2[0] = 0.0f;
                        fArray2[1] = 0.0f;
                    }
                    if (!(fArray2[0] > f) && !(fArray2[1] > f)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(final FComplexMatrix3D fComplexMatrix3D, final FComplexMatrix3D fComplexMatrix3D2) {
        if (fComplexMatrix3D == fComplexMatrix3D2) {
            return true;
        }
        if (fComplexMatrix3D == null || fComplexMatrix3D2 == null) {
            return false;
        }
        boolean bl = false;
        int n = fComplexMatrix3D.slices();
        final int n2 = fComplexMatrix3D.rows();
        final int n3 = fComplexMatrix3D.columns();
        if (n3 != fComplexMatrix3D2.columns() || n2 != fComplexMatrix3D2.rows() || n != fComplexMatrix3D2.slices()) {
            return false;
        }
        final float f = this.tolerance();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && fComplexMatrix3D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, n);
            Future[] futureArray = new Future[n4];
            Boolean[] booleanArray = new Boolean[n4];
            int n6 = n / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] fArray = new float[2];
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    float[] fArray2 = fComplexMatrix3D.getQuick(i, j, k);
                                    float[] fArray3 = fComplexMatrix3D2.getQuick(i, j, k);
                                    fArray[0] = Math.abs(fArray3[0] - fArray2[0]);
                                    fArray[1] = Math.abs(fArray3[1] - fArray2[1]);
                                    if (!((fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1] || fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1]) && !FComplex.isEqual(fArray3, fArray2, f))) {
                                        fArray[0] = 0.0f;
                                        fArray[1] = 0.0f;
                                    }
                                    if (!(fArray[0] > f) && !(fArray[1] > f)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    booleanArray[n5] = (Boolean)futureArray[n5].get();
                }
                bl = booleanArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    bl = bl && booleanArray[n5] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        float[] fArray = new float[2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    float[] fArray2 = fComplexMatrix3D.getQuick(i, j, k);
                    float[] fArray3 = fComplexMatrix3D2.getQuick(i, j, k);
                    fArray[0] = Math.abs(fArray3[0] - fArray2[0]);
                    fArray[1] = Math.abs(fArray3[1] - fArray2[1]);
                    if (!((fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1] || fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1]) && !FComplex.isEqual(fArray3, fArray2, f))) {
                        fArray[0] = 0.0f;
                        fArray[1] = 0.0f;
                    }
                    if (!(fArray[0] > f) && !(fArray[1] > f)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

