/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.function.tbyte.ByteComparator;
import cern.colt.function.tchar.CharComparator;
import cern.colt.function.tdouble.DoubleComparator;
import cern.colt.function.tfloat.FloatComparator;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tlong.LongComparator;
import cern.colt.function.tshort.ShortComparator;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class ParallelQuickSort {
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    public static void quickSort(final byte[] byArray, final int n, int n2, final ByteComparator byteComparator, final int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && byteComparator.compare(byArray[j - 1], byArray[j]) > 0; --j) {
                    ParallelQuickSort.swap(byArray, j, j - 1);
                }
            }
            return;
        }
        int n8 = n + n2 / 2;
        if (n2 > 7) {
            int n9;
            int by = n;
            n7 = n + n2 - 1;
            if (n2 > 40) {
                n6 = n2 / 8;
                n9 = ParallelQuickSort.med3(byArray, by, by + n6, by + 2 * n6, byteComparator);
                n8 = ParallelQuickSort.med3(byArray, n8 - n6, n8, n8 + n6, byteComparator);
                n7 = ParallelQuickSort.med3(byArray, n7 - 2 * n6, n7 - n6, n7, byteComparator);
            }
            n8 = ParallelQuickSort.med3(byArray, n9, n8, n7, byteComparator);
        }
        byte by = byArray[n8];
        n6 = n7 = n;
        int n10 = n5 = n + n2 - 1;
        while (true) {
            if (n6 <= n5 && (n4 = byteComparator.compare(byArray[n6], by)) <= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(byArray, n7++, n6);
                }
                ++n6;
                continue;
            }
            while (n5 >= n6 && (n4 = byteComparator.compare(byArray[n5], by)) >= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(byArray, n5, n10--);
                }
                --n5;
            }
            if (n6 > n5) break;
            ParallelQuickSort.swap(byArray, n6++, n5--);
        }
        int n11 = n + n2;
        n4 = Math.min(n7 - n, n6 - n7);
        ParallelQuickSort.vecswap(byArray, n, n6 - n4, n4);
        n4 = Math.min(n10 - n5, n11 - n10 - 1);
        ParallelQuickSort.vecswap(byArray, n6, n11 - n4, n4);
        Future future = null;
        if (n3 > 1) {
            int executionException;
            n4 = n6 - n7;
            if (n4 > 1) {
                executionException = n4;
                future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(byArray, n, executionException, byteComparator, n3 / 2);
                    }
                });
            }
            if ((n4 = n10 - n5) > 1) {
                if (future == null) {
                    executionException = n4;
                    final int n12 = n11 - n4;
                    future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(byArray, n12, executionException, byteComparator, n3 / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(byArray, n11 - n4, n4, byteComparator, n3 / 2);
                }
            }
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException executionException2) {
                executionException2.printStackTrace();
            }
        } else {
            n4 = n6 - n7;
            if (n4 > 1) {
                ParallelQuickSort.quickSort(byArray, n, n4, byteComparator, 1);
            }
            if ((n4 = n10 - n5) > 1) {
                ParallelQuickSort.quickSort(byArray, n11 - n4, n4, byteComparator, 1);
            }
        }
    }

    public static void quickSort(final char[] cArray, final int n, int n2, final CharComparator charComparator, final int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && charComparator.compare(cArray[j - 1], cArray[j]) > 0; --j) {
                    ParallelQuickSort.swap(cArray, j, j - 1);
                }
            }
            return;
        }
        int n8 = n + n2 / 2;
        if (n2 > 7) {
            int n9;
            int c = n;
            n7 = n + n2 - 1;
            if (n2 > 40) {
                n6 = n2 / 8;
                n9 = ParallelQuickSort.med3(cArray, c, c + n6, c + 2 * n6, charComparator);
                n8 = ParallelQuickSort.med3(cArray, n8 - n6, n8, n8 + n6, charComparator);
                n7 = ParallelQuickSort.med3(cArray, n7 - 2 * n6, n7 - n6, n7, charComparator);
            }
            n8 = ParallelQuickSort.med3(cArray, n9, n8, n7, charComparator);
        }
        char c = cArray[n8];
        n6 = n7 = n;
        int n10 = n5 = n + n2 - 1;
        while (true) {
            if (n6 <= n5 && (n4 = charComparator.compare(cArray[n6], c)) <= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(cArray, n7++, n6);
                }
                ++n6;
                continue;
            }
            while (n5 >= n6 && (n4 = charComparator.compare(cArray[n5], c)) >= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(cArray, n5, n10--);
                }
                --n5;
            }
            if (n6 > n5) break;
            ParallelQuickSort.swap(cArray, n6++, n5--);
        }
        int n11 = n + n2;
        n4 = Math.min(n7 - n, n6 - n7);
        ParallelQuickSort.vecswap(cArray, n, n6 - n4, n4);
        n4 = Math.min(n10 - n5, n11 - n10 - 1);
        ParallelQuickSort.vecswap(cArray, n6, n11 - n4, n4);
        Future future = null;
        if (n3 > 1) {
            int executionException;
            n4 = n6 - n7;
            if (n4 > 1) {
                executionException = n4;
                future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(cArray, n, executionException, charComparator, n3 / 2);
                    }
                });
            }
            if ((n4 = n10 - n5) > 1) {
                if (future == null) {
                    executionException = n4;
                    final int n12 = n11 - n4;
                    future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(cArray, n12, executionException, charComparator, n3 / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(cArray, n11 - n4, n4, charComparator, n3 / 2);
                }
            }
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException executionException2) {
                executionException2.printStackTrace();
            }
        } else {
            n4 = n6 - n7;
            if (n4 > 1) {
                ParallelQuickSort.quickSort(cArray, n, n4, charComparator, 1);
            }
            if ((n4 = n10 - n5) > 1) {
                ParallelQuickSort.quickSort(cArray, n11 - n4, n4, charComparator, 1);
            }
        }
    }

    public static void quickSort(final double[] dArray, final int n, int n2, final DoubleComparator doubleComparator, final int n3) {
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && doubleComparator.compare(dArray[j - 1], dArray[j]) > 0; --j) {
                    ParallelQuickSort.swap(dArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + n2 / 2;
        if (n2 > 7) {
            int n8 = n;
            int n9 = n + n2 - 1;
            if (n2 > 40) {
                n6 = n2 / 8;
                n8 = ParallelQuickSort.med3(dArray, n8, n8 + n6, n8 + 2 * n6, doubleComparator);
                n7 = ParallelQuickSort.med3(dArray, n7 - n6, n7, n7 + n6, doubleComparator);
                n9 = ParallelQuickSort.med3(dArray, n9 - 2 * n6, n9 - n6, n9, doubleComparator);
            }
            n7 = ParallelQuickSort.med3(dArray, n8, n7, n9, doubleComparator);
        }
        double d = dArray[n7];
        int n10 = n6 = n;
        int n11 = n5 = n + n2 - 1;
        while (true) {
            if (n10 <= n5 && (n4 = doubleComparator.compare(dArray[n10], d)) <= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(dArray, n6++, n10);
                }
                ++n10;
                continue;
            }
            while (n5 >= n10 && (n4 = doubleComparator.compare(dArray[n5], d)) >= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(dArray, n5, n11--);
                }
                --n5;
            }
            if (n10 > n5) break;
            ParallelQuickSort.swap(dArray, n10++, n5--);
        }
        int n12 = n + n2;
        n4 = Math.min(n6 - n, n10 - n6);
        ParallelQuickSort.vecswap(dArray, n, n10 - n4, n4);
        n4 = Math.min(n11 - n5, n12 - n11 - 1);
        ParallelQuickSort.vecswap(dArray, n10, n12 - n4, n4);
        Future future = null;
        if (n3 > 1) {
            int n13;
            n4 = n10 - n6;
            if (n4 > 1) {
                n13 = n4;
                future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(dArray, n, n13, doubleComparator, n3 / 2);
                    }
                });
            }
            if ((n4 = n11 - n5) > 1) {
                if (future == null) {
                    n13 = n4;
                    final int n14 = n12 - n4;
                    future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(dArray, n14, n13, doubleComparator, n3 / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(dArray, n12 - n4, n4, doubleComparator, n3 / 2);
                }
            }
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        } else {
            n4 = n10 - n6;
            if (n4 > 1) {
                ParallelQuickSort.quickSort(dArray, n, n4, doubleComparator, 1);
            }
            if ((n4 = n11 - n5) > 1) {
                ParallelQuickSort.quickSort(dArray, n12 - n4, n4, doubleComparator, 1);
            }
        }
    }

    public static void quickSort(final float[] fArray, final int n, int n2, final FloatComparator floatComparator, final int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && floatComparator.compare(fArray[j - 1], fArray[j]) > 0; --j) {
                    ParallelQuickSort.swap(fArray, j, j - 1);
                }
            }
            return;
        }
        int n8 = n + n2 / 2;
        if (n2 > 7) {
            int n9 = n;
            n7 = n + n2 - 1;
            if (n2 > 40) {
                n6 = n2 / 8;
                n9 = ParallelQuickSort.med3(fArray, n9, n9 + n6, n9 + 2 * n6, floatComparator);
                n8 = ParallelQuickSort.med3(fArray, n8 - n6, n8, n8 + n6, floatComparator);
                n7 = ParallelQuickSort.med3(fArray, n7 - 2 * n6, n7 - n6, n7, floatComparator);
            }
            n8 = ParallelQuickSort.med3(fArray, n9, n8, n7, floatComparator);
        }
        float f = fArray[n8];
        n6 = n7 = n;
        int n10 = n5 = n + n2 - 1;
        while (true) {
            if (n6 <= n5 && (n4 = floatComparator.compare(fArray[n6], f)) <= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(fArray, n7++, n6);
                }
                ++n6;
                continue;
            }
            while (n5 >= n6 && (n4 = floatComparator.compare(fArray[n5], f)) >= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(fArray, n5, n10--);
                }
                --n5;
            }
            if (n6 > n5) break;
            ParallelQuickSort.swap(fArray, n6++, n5--);
        }
        int n11 = n + n2;
        n4 = Math.min(n7 - n, n6 - n7);
        ParallelQuickSort.vecswap(fArray, n, n6 - n4, n4);
        n4 = Math.min(n10 - n5, n11 - n10 - 1);
        ParallelQuickSort.vecswap(fArray, n6, n11 - n4, n4);
        Future future = null;
        if (n3 > 1) {
            int n12;
            n4 = n6 - n7;
            if (n4 > 1) {
                n12 = n4;
                future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(fArray, n, n12, floatComparator, n3 / 2);
                    }
                });
            }
            if ((n4 = n10 - n5) > 1) {
                if (future == null) {
                    n12 = n4;
                    final int n13 = n11 - n4;
                    future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(fArray, n13, n12, floatComparator, n3 / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(fArray, n11 - n4, n4, floatComparator, n3 / 2);
                }
            }
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        } else {
            n4 = n6 - n7;
            if (n4 > 1) {
                ParallelQuickSort.quickSort(fArray, n, n4, floatComparator, 1);
            }
            if ((n4 = n10 - n5) > 1) {
                ParallelQuickSort.quickSort(fArray, n11 - n4, n4, floatComparator, 1);
            }
        }
    }

    public static void quickSort(final int[] nArray, final int n, int n2, final IntComparator intComparator, final int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && intComparator.compare(nArray[j - 1], nArray[j]) > 0; --j) {
                    ParallelQuickSort.swap(nArray, j, j - 1);
                }
            }
            return;
        }
        int n9 = n + n2 / 2;
        if (n2 > 7) {
            n8 = n;
            n7 = n + n2 - 1;
            if (n2 > 40) {
                n6 = n2 / 8;
                n8 = ParallelQuickSort.med3(nArray, n8, n8 + n6, n8 + 2 * n6, intComparator);
                n9 = ParallelQuickSort.med3(nArray, n9 - n6, n9, n9 + n6, intComparator);
                n7 = ParallelQuickSort.med3(nArray, n7 - 2 * n6, n7 - n6, n7, intComparator);
            }
            n9 = ParallelQuickSort.med3(nArray, n8, n9, n7, intComparator);
        }
        n8 = nArray[n9];
        n6 = n7 = n;
        int n10 = n5 = n + n2 - 1;
        while (true) {
            if (n6 <= n5 && (n4 = intComparator.compare(nArray[n6], n8)) <= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(nArray, n7++, n6);
                }
                ++n6;
                continue;
            }
            while (n5 >= n6 && (n4 = intComparator.compare(nArray[n5], n8)) >= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(nArray, n5, n10--);
                }
                --n5;
            }
            if (n6 > n5) break;
            ParallelQuickSort.swap(nArray, n6++, n5--);
        }
        int n11 = n + n2;
        n4 = Math.min(n7 - n, n6 - n7);
        ParallelQuickSort.vecswap(nArray, n, n6 - n4, n4);
        n4 = Math.min(n10 - n5, n11 - n10 - 1);
        ParallelQuickSort.vecswap(nArray, n6, n11 - n4, n4);
        Future future = null;
        if (n3 > 1) {
            int n12;
            n4 = n6 - n7;
            if (n4 > 1) {
                n12 = n4;
                future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(nArray, n, n12, intComparator, n3 / 2);
                    }
                });
            }
            if ((n4 = n10 - n5) > 1) {
                if (future == null) {
                    n12 = n4;
                    final int n13 = n11 - n4;
                    future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(nArray, n13, n12, intComparator, n3 / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(nArray, n11 - n4, n4, intComparator, n3 / 2);
                }
            }
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        } else {
            n4 = n6 - n7;
            if (n4 > 1) {
                ParallelQuickSort.quickSort(nArray, n, n4, intComparator, 1);
            }
            if ((n4 = n10 - n5) > 1) {
                ParallelQuickSort.quickSort(nArray, n11 - n4, n4, intComparator, 1);
            }
        }
    }

    public static void quickSort(final long[] lArray, final int n, int n2, final LongComparator longComparator, final int n3) {
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && longComparator.compare(lArray[j - 1], lArray[j]) > 0; --j) {
                    ParallelQuickSort.swap(lArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + n2 / 2;
        if (n2 > 7) {
            int n8 = n;
            int n9 = n + n2 - 1;
            if (n2 > 40) {
                n6 = n2 / 8;
                n8 = ParallelQuickSort.med3(lArray, n8, n8 + n6, n8 + 2 * n6, longComparator);
                n7 = ParallelQuickSort.med3(lArray, n7 - n6, n7, n7 + n6, longComparator);
                n9 = ParallelQuickSort.med3(lArray, n9 - 2 * n6, n9 - n6, n9, longComparator);
            }
            n7 = ParallelQuickSort.med3(lArray, n8, n7, n9, longComparator);
        }
        long l = lArray[n7];
        int n10 = n6 = n;
        int n11 = n5 = n + n2 - 1;
        while (true) {
            if (n10 <= n5 && (n4 = longComparator.compare(lArray[n10], l)) <= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(lArray, n6++, n10);
                }
                ++n10;
                continue;
            }
            while (n5 >= n10 && (n4 = longComparator.compare(lArray[n5], l)) >= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(lArray, n5, n11--);
                }
                --n5;
            }
            if (n10 > n5) break;
            ParallelQuickSort.swap(lArray, n10++, n5--);
        }
        int n12 = n + n2;
        n4 = Math.min(n6 - n, n10 - n6);
        ParallelQuickSort.vecswap(lArray, n, n10 - n4, n4);
        n4 = Math.min(n11 - n5, n12 - n11 - 1);
        ParallelQuickSort.vecswap(lArray, n10, n12 - n4, n4);
        Future future = null;
        if (n3 > 1) {
            int n13;
            n4 = n10 - n6;
            if (n4 > 1) {
                n13 = n4;
                future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(lArray, n, n13, longComparator, n3 / 2);
                    }
                });
            }
            if ((n4 = n11 - n5) > 1) {
                if (future == null) {
                    n13 = n4;
                    final int n14 = n12 - n4;
                    future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(lArray, n14, n13, longComparator, n3 / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(lArray, n12 - n4, n4, longComparator, n3 / 2);
                }
            }
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        } else {
            n4 = n10 - n6;
            if (n4 > 1) {
                ParallelQuickSort.quickSort(lArray, n, n4, longComparator, 1);
            }
            if ((n4 = n11 - n5) > 1) {
                ParallelQuickSort.quickSort(lArray, n12 - n4, n4, longComparator, 1);
            }
        }
    }

    public static void quickSort(final Object[] objectArray, final int n, int n2, final int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && ((Comparable)objectArray[j - 1]).compareTo(objectArray[j]) > 0; --j) {
                    ParallelQuickSort.swap(objectArray, j, j - 1);
                }
            }
            return;
        }
        int n8 = n + n2 / 2;
        if (n2 > 7) {
            int n9 = n;
            n7 = n + n2 - 1;
            if (n2 > 40) {
                n6 = n2 / 8;
                n9 = ParallelQuickSort.med3(objectArray, n9, n9 + n6, n9 + 2 * n6);
                n8 = ParallelQuickSort.med3(objectArray, n8 - n6, n8, n8 + n6);
                n7 = ParallelQuickSort.med3(objectArray, n7 - 2 * n6, n7 - n6, n7);
            }
            n8 = ParallelQuickSort.med3(objectArray, n9, n8, n7);
        }
        Comparable comparable = (Comparable)objectArray[n8];
        n6 = n7 = n;
        int n10 = n5 = n + n2 - 1;
        while (true) {
            if (n6 <= n5 && (n4 = ((Comparable)objectArray[n6]).compareTo(comparable)) <= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(objectArray, n7++, n6);
                }
                ++n6;
                continue;
            }
            while (n5 >= n6 && (n4 = ((Comparable)objectArray[n5]).compareTo(comparable)) >= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(objectArray, n5, n10--);
                }
                --n5;
            }
            if (n6 > n5) break;
            ParallelQuickSort.swap(objectArray, n6++, n5--);
        }
        int n11 = n + n2;
        n4 = Math.min(n7 - n, n6 - n7);
        ParallelQuickSort.vecswap(objectArray, n, n6 - n4, n4);
        n4 = Math.min(n10 - n5, n11 - n10 - 1);
        ParallelQuickSort.vecswap(objectArray, n6, n11 - n4, n4);
        Future future = null;
        if (n3 > 1) {
            int n12;
            n4 = n6 - n7;
            if (n4 > 1) {
                n12 = n4;
                future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(objectArray, n, n12, n3 / 2);
                    }
                });
            }
            if ((n4 = n10 - n5) > 1) {
                if (future == null) {
                    n12 = n4;
                    final int n13 = n11 - n4;
                    future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(objectArray, n13, n12, n3 / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(objectArray, n11 - n4, n4, n3 / 2);
                }
            }
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        } else {
            n4 = n6 - n7;
            if (n4 > 1) {
                ParallelQuickSort.quickSort(objectArray, n, n4, 1);
            }
            if ((n4 = n10 - n5) > 1) {
                ParallelQuickSort.quickSort(objectArray, n11 - n4, n4, 1);
            }
        }
    }

    public static void quickSort(final Object[] objectArray, final int n, int n2, final Comparator comparator, final int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && comparator.compare(objectArray[j - 1], objectArray[j]) > 0; --j) {
                    ParallelQuickSort.swap(objectArray, j, j - 1);
                }
            }
            return;
        }
        int n8 = n + n2 / 2;
        if (n2 > 7) {
            int n9 = n;
            n7 = n + n2 - 1;
            if (n2 > 40) {
                n6 = n2 / 8;
                n9 = ParallelQuickSort.med3(objectArray, n9, n9 + n6, n9 + 2 * n6, comparator);
                n8 = ParallelQuickSort.med3(objectArray, n8 - n6, n8, n8 + n6, comparator);
                n7 = ParallelQuickSort.med3(objectArray, n7 - 2 * n6, n7 - n6, n7, comparator);
            }
            n8 = ParallelQuickSort.med3(objectArray, n9, n8, n7, comparator);
        }
        Object object = objectArray[n8];
        n6 = n7 = n;
        int n10 = n5 = n + n2 - 1;
        while (true) {
            if (n6 <= n5 && (n4 = comparator.compare(objectArray[n6], object)) <= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(objectArray, n7++, n6);
                }
                ++n6;
                continue;
            }
            while (n5 >= n6 && (n4 = comparator.compare(objectArray[n5], object)) >= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(objectArray, n5, n10--);
                }
                --n5;
            }
            if (n6 > n5) break;
            ParallelQuickSort.swap(objectArray, n6++, n5--);
        }
        int n11 = n + n2;
        n4 = Math.min(n7 - n, n6 - n7);
        ParallelQuickSort.vecswap(objectArray, n, n6 - n4, n4);
        n4 = Math.min(n10 - n5, n11 - n10 - 1);
        ParallelQuickSort.vecswap(objectArray, n6, n11 - n4, n4);
        Future future = null;
        if (n3 > 1) {
            int n12;
            n4 = n6 - n7;
            if (n4 > 1) {
                n12 = n4;
                future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(objectArray, n, n12, comparator, n3 / 2);
                    }
                });
            }
            if ((n4 = n10 - n5) > 1) {
                if (future == null) {
                    n12 = n4;
                    final int n13 = n11 - n4;
                    future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(objectArray, n13, n12, comparator, n3 / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(objectArray, n11 - n4, n4, comparator, n3 / 2);
                }
            }
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        } else {
            n4 = n6 - n7;
            if (n4 > 1) {
                ParallelQuickSort.quickSort(objectArray, n, n4, comparator, 1);
            }
            if ((n4 = n10 - n5) > 1) {
                ParallelQuickSort.quickSort(objectArray, n11 - n4, n4, comparator, 1);
            }
        }
    }

    public static void quickSort(final short[] sArray, final int n, int n2, final ShortComparator shortComparator, final int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && shortComparator.compare(sArray[j - 1], sArray[j]) > 0; --j) {
                    ParallelQuickSort.swap(sArray, j, j - 1);
                }
            }
            return;
        }
        int n8 = n + n2 / 2;
        if (n2 > 7) {
            int n9;
            int s = n;
            n7 = n + n2 - 1;
            if (n2 > 40) {
                n6 = n2 / 8;
                n9 = ParallelQuickSort.med3(sArray, s, s + n6, s + 2 * n6, shortComparator);
                n8 = ParallelQuickSort.med3(sArray, n8 - n6, n8, n8 + n6, shortComparator);
                n7 = ParallelQuickSort.med3(sArray, n7 - 2 * n6, n7 - n6, n7, shortComparator);
            }
            n8 = ParallelQuickSort.med3(sArray, n9, n8, n7, shortComparator);
        }
        short s = sArray[n8];
        n6 = n7 = n;
        int n10 = n5 = n + n2 - 1;
        while (true) {
            if (n6 <= n5 && (n4 = shortComparator.compare(sArray[n6], s)) <= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(sArray, n7++, n6);
                }
                ++n6;
                continue;
            }
            while (n5 >= n6 && (n4 = shortComparator.compare(sArray[n5], s)) >= 0) {
                if (n4 == 0) {
                    ParallelQuickSort.swap(sArray, n5, n10--);
                }
                --n5;
            }
            if (n6 > n5) break;
            ParallelQuickSort.swap(sArray, n6++, n5--);
        }
        int n11 = n + n2;
        n4 = Math.min(n7 - n, n6 - n7);
        ParallelQuickSort.vecswap(sArray, n, n6 - n4, n4);
        n4 = Math.min(n10 - n5, n11 - n10 - 1);
        ParallelQuickSort.vecswap(sArray, n6, n11 - n4, n4);
        Future future = null;
        if (n3 > 1) {
            int executionException;
            n4 = n6 - n7;
            if (n4 > 1) {
                executionException = n4;
                future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        ParallelQuickSort.quickSort(sArray, n, executionException, shortComparator, n3 / 2);
                    }
                });
            }
            if ((n4 = n10 - n5) > 1) {
                if (future == null) {
                    executionException = n4;
                    final int n12 = n11 - n4;
                    future = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            ParallelQuickSort.quickSort(sArray, n12, executionException, shortComparator, n3 / 2);
                        }
                    });
                } else {
                    ParallelQuickSort.quickSort(sArray, n11 - n4, n4, shortComparator, n3 / 2);
                }
            }
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("thread interrupted");
            }
            catch (ExecutionException executionException2) {
                executionException2.printStackTrace();
            }
        } else {
            n4 = n6 - n7;
            if (n4 > 1) {
                ParallelQuickSort.quickSort(sArray, n, n4, shortComparator, 1);
            }
            if ((n4 = n10 - n5) > 1) {
                ParallelQuickSort.quickSort(sArray, n11 - n4, n4, shortComparator, 1);
            }
        }
    }

    private static void swap(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    private static void swap(char[] cArray, int n, int n2) {
        char c = cArray[n];
        cArray[n] = cArray[n2];
        cArray[n2] = c;
    }

    private static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    private static void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    private static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static void swap(long[] lArray, int n, int n2) {
        long l = lArray[n];
        lArray[n] = lArray[n2];
        lArray[n2] = l;
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    private static void swap(short[] sArray, int n, int n2) {
        short s = sArray[n];
        sArray[n] = sArray[n2];
        sArray[n2] = s;
    }

    private static void vecswap(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            ParallelQuickSort.swap(byArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            ParallelQuickSort.swap(cArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(double[] dArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            ParallelQuickSort.swap(dArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(float[] fArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            ParallelQuickSort.swap(fArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            ParallelQuickSort.swap(nArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(long[] lArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            ParallelQuickSort.swap(lArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(Object[] objectArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            ParallelQuickSort.swap(objectArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static void vecswap(short[] sArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            ParallelQuickSort.swap(sArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static int med3(byte[] byArray, int n, int n2, int n3, ByteComparator byteComparator) {
        int n4 = byteComparator.compare(byArray[n], byArray[n2]);
        int n5 = byteComparator.compare(byArray[n], byArray[n3]);
        int n6 = byteComparator.compare(byArray[n2], byArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(char[] cArray, int n, int n2, int n3, CharComparator charComparator) {
        int n4 = charComparator.compare(cArray[n], cArray[n2]);
        int n5 = charComparator.compare(cArray[n], cArray[n3]);
        int n6 = charComparator.compare(cArray[n2], cArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(double[] dArray, int n, int n2, int n3, DoubleComparator doubleComparator) {
        int n4 = doubleComparator.compare(dArray[n], dArray[n2]);
        int n5 = doubleComparator.compare(dArray[n], dArray[n3]);
        int n6 = doubleComparator.compare(dArray[n2], dArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(float[] fArray, int n, int n2, int n3, FloatComparator floatComparator) {
        int n4 = floatComparator.compare(fArray[n], fArray[n2]);
        int n5 = floatComparator.compare(fArray[n], fArray[n3]);
        int n6 = floatComparator.compare(fArray[n2], fArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(int[] nArray, int n, int n2, int n3, IntComparator intComparator) {
        int n4 = intComparator.compare(nArray[n], nArray[n2]);
        int n5 = intComparator.compare(nArray[n], nArray[n3]);
        int n6 = intComparator.compare(nArray[n2], nArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(long[] lArray, int n, int n2, int n3, LongComparator longComparator) {
        int n4 = longComparator.compare(lArray[n], lArray[n2]);
        int n5 = longComparator.compare(lArray[n], lArray[n3]);
        int n6 = longComparator.compare(lArray[n2], lArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(Object[] objectArray, int n, int n2, int n3) {
        int n4 = ((Comparable)objectArray[n]).compareTo(objectArray[n2]);
        int n5 = ((Comparable)objectArray[n]).compareTo(objectArray[n3]);
        int n6 = ((Comparable)objectArray[n2]).compareTo(objectArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(Object[] objectArray, int n, int n2, int n3, Comparator comparator) {
        int n4 = comparator.compare(objectArray[n], objectArray[n2]);
        int n5 = comparator.compare(objectArray[n], objectArray[n3]);
        int n6 = comparator.compare(objectArray[n2], objectArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }

    private static int med3(short[] sArray, int n, int n2, int n3, ShortComparator shortComparator) {
        int n4 = shortComparator.compare(sArray[n], sArray[n2]);
        int n5 = shortComparator.compare(sArray[n], sArray[n3]);
        int n6 = shortComparator.compare(sArray[n2], sArray[n3]);
        return n4 < 0 ? (n6 < 0 ? n2 : (n5 < 0 ? n3 : n)) : (n6 > 0 ? n2 : (n5 > 0 ? n3 : n));
    }
}

