% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.IM4E.R
\name{predict.IM4E}
\alias{predict.IM4E}
\title{predict.IM4E}
\usage{
\method{predict}{IM4E}(object, xx, yy, newx, sig = 1, type = "both", ...)
}
\arguments{
\item{object}{weight or result of IM4E algorithm}

\item{xx}{model matrix of explanatory variables}

\item{yy}{label vector}

\item{newx}{model matrix to be predicted}

\item{sig}{sigma used in algorithm, default to be 1}

\item{type}{the form of final output, default to be "both"}

\item{...}{further arguments passed to or from other methods}
}
\value{
\item{response}{preded probabilities for newx}

\item{class}{ preded class for newx}
}
\description{
This function performs the predition for IM4E(Iterative Margin-Maximization under Max-Min Entropy) algorithm.
}
\examples{
data(park)
xx<-park$xx
yy<-park$yy
index<-c(1:floor(nrow(xx)*0.3))
train_xx<-xx[-index,]
test_xx<-xx[index,]
train_yy<-yy[-index]
test_yy<-yy[index]
re<-IM4E(train_xx,train_yy)
res<-predict(re,train_xx,train_yy,test_xx,type="class")
print(res)

}
\keyword{IM4E}
\keyword{predict}
