% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodesicAreas.R
\name{get_area}
\alias{get_area}
\title{Calculate geodesic area}
\usage{
get_area(poly, byid = FALSE)
}
\arguments{
\item{poly}{\code{SpatialPolygons} object for which to calculate area}

\item{byid}{boolean indicating whether areas should be calculated for each
polygon individually or for the whole object together}
}
\value{
Area of polygon (or vector of areas if \code{byid} is set to \code{TRUE})
}
\description{
Caclulate the geodesic areas of \code{SpatialPolygons} object on the Nothern
Hemisphere Polar Stereographic grid projection
}
\details{
Area calculations are for the Polar stereographic grid with major
         axis of 6378273m and ellipsoid flattening of 1/298.2794111.
}
\examples{
get_area(reg_info$regions[[1]])
get_area(land, byid = TRUE)
}
\references{
Information on Polar Stereographic North projection:
            \url{https://nsidc.org/data/polar-stereo/ps_grids.html}
}
