% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EI_network_function.R
\name{ei_network}
\alias{ei_network}
\title{Network level E-I Index}
\usage{
ei_network(gs, attrname)
}
\arguments{
\item{gs}{igraph object}

\item{attrname}{Attribute name}
}
\value{
Group level results dataframe
}
\description{
This function calculates the E-I Index (External-internal) at the network level
}
\examples{
require(igraph)
##Create random network (igraph object)
gs<-erdos.renyi.game(75,0.05,directed = TRUE)

##Add vertex names
V(gs)$name<-1:vcount(gs)

## Add an attribute
V(gs)$letters<- rep(LETTERS[1:5],15)

##Calculate the Group E-I Results
EI_NETWORK<-ei_network(gs,"letters")

}
